# 🔧 حل مشکل "پلن انتخاب میکنم ادامه نمیاره"

## 🎯 مشکل شما:
وقتی میخواید خرید کنید و از لیست پلن‌ها یکی رو انتخاب می‌کنید، ادامه مسیر نمیاد.

---

## ✅ راه حل (گام به گام):

### مرحله 1: بررسی وضعیت سیستم

این فایل رو از مرورگر باز کنید:
```
http://DOMAIN-SHOMA/test_buy_flow.php
```

این صفحه به شما نشون میده که:
- ✅ آیا دسته‌بندی‌ها موجودن؟
- ✅ آیا سرورها فعالن؟
- ✅ آیا تعرفه‌ها موجودن؟
- ✅ آیا جداول کامل هستن؟

---

### مرحله 2: اضافه کردن داده‌های نمونه

اگه تو مرحله 1 دیدید که دسته‌بندی یا پلن نداره، این فایل رو اجرا کنید:
```
http://DOMAIN-SHOMA/add_sample_data.php
```

این فایل به صورت اتوماتیک:
- ✅ 3 دسته‌بندی اضافه می‌کنه (استاندارد، پریمیوم، VIP)
- ✅ 1 سرور نمونه اضافه می‌کنه
- ✅ 9 تعرفه مختلف اضافه می‌کنه

**⚠️ نکته:** این فایل رو فقط یک بار اجرا کنید!

---

### مرحله 3: ریستارت Webhook

بعد از اضافه کردن داده‌ها، webhook رو دوباره ست کنید:
```
http://DOMAIN-SHOMA/setWebhook.php
```

یا از فایل `deleteWebhook.php` استفاده کنید و دوباره ست کنید:
```
http://DOMAIN-SHOMA/deleteWebhook.php
http://DOMAIN-SHOMA/setWebhook.php
```

---

### مرحله 4: تست کردن

حالا به ربات برید و این مراحل رو دنبال کنید:

1. **دستور /start بزنید**
   - باید منوی اصلی نمایش داده بشه

2. **روی "🔥 خرید سرویس APN" کلیک کنید**
   - باید لیست دسته‌بندی‌ها نمایش داده بشه
   - مثلا: 📦 پلن استاندارد، ⭐ پلن پریمیوم، 👑 پلن VIP

3. **یک دسته انتخاب کنید (مثلا پلن استاندارد)**
   - باید لیست تعرفه‌های اون دسته نمایش داده بشه
   - مثلا: 10 گیگ، 20 گیگ، 30 گیگ

4. **یک پلن انتخاب کنید (مثلا 20 گیگ)**
   - باید صفحه تایید خرید نمایش داده بشه
   - با دو گزینه: پرداخت از کیف پول / پرداخت فیش بانکی

---

## 🐛 اگه هنوز کار نکرد:

### مشکل 1: دسته‌بندی‌ها نمایش داده نمیشن

**علت:** جدول `plan_categories` خالیه

**راه حل:**
```sql
-- این کد رو در phpMyAdmin اجرا کنید:
INSERT INTO `plan_categories` (`name`, `emoji`, `status`, `sort_order`) VALUES
('پلن استاندارد', '📦', 'active', 1),
('پلن پریمیوم', '⭐', 'active', 2),
('پلن VIP', '👑', 'active', 3);
```

---

### مشکل 2: پلن‌ها نمایش داده نمیشن

**علت:** جدول `service_plans` خالیه یا سرور فعال نداره

**راه حل:**
1. اول سرور اضافه کنید:
```sql
INSERT INTO `servers` 
(`name`, `location`, `server_ip`, `panel_port`, `panel_path`, `panel_username`, `panel_password`, `protocol`, `inbound_id`, `status`) 
VALUES 
('سرور آلمان', 'Germany 🇩🇪', '82.115.26.209', 2053, '/panel', 'admin', 'admin123', 'vless', 1, 'active');
```

2. بعد تعرفه اضافه کنید:
```sql
-- فرض کنیم ID سرور = 1 و ID دسته استاندارد = 1
INSERT INTO `service_plans` 
(`category_id`, `server_id`, `name`, `volume_gb`, `days`, `price`, `status`) 
VALUES 
(1, 1, '20 گیگ یک ماهه', 20, 30, 90000, 'active');
```

---

### مشکل 3: بعد از انتخاب پلن، هیچ اتفاقی نمی‌افته

**علت:** handler مربوط به `buyPlan_` کار نمی‌کنه

**راه حل:**
1. لاگ خطاها رو چک کنید:
```
tail -f /var/log/apache2/error.log
```

2. مطمئن شید فایل `bot.php` به‌روز شده

3. کش تلگرام رو پاک کنید:
   - ربات رو از چت حذف کنید
   - دوباره /start بزنید

---

### مشکل 4: خطای "تعرفه یافت نشد"

**علت:** رابطه بین جداول درست نیست

**راه حل:**
بررسی کنید که:
- `service_plans.category_id` با `plan_categories.id` مطابقت داره
- `service_plans.server_id` با `servers.id` مطابقت داره
- همه status ها 'active' هستن

---

## 📊 دستورات مفید برای دیباگ:

### چک کردن دسته‌بندی‌ها:
```sql
SELECT * FROM plan_categories WHERE status='active';
```

### چک کردن سرورها:
```sql
SELECT * FROM servers WHERE status='active';
```

### چک کردن تعرفه‌ها با جزئیات:
```sql
SELECT 
    sp.id,
    sp.name,
    pc.name as category,
    s.name as server,
    sp.volume_gb,
    sp.days,
    sp.price,
    sp.status
FROM service_plans sp
LEFT JOIN plan_categories pc ON sp.category_id = pc.id
LEFT JOIN servers s ON sp.server_id = s.id
WHERE sp.status = 'active';
```

### مشاهده لاگ‌های ساخت سرویس:
```bash
cat logs/service_creation_*.log
```

---

## ✅ چک لیست نهایی:

قبل از تست، این موارد رو چک کنید:

- [ ] جدول `plan_categories` حداقل یک رکورد با status='active' داره
- [ ] جدول `servers` حداقل یک رکورد با status='active' داره  
- [ ] جدول `service_plans` حداقل یک رکورد با status='active' داره
- [ ] فایل `bot.php` آپدیت شده
- [ ] Webhook دوباره ست شده
- [ ] کش تلگرام پاک شده

---

## 🆘 اگه هیچ کدوم کار نکرد:

1. فایل `test_buy_flow.php` رو اجرا کنید و اسکرین‌شات بگیرید
2. خطاهای PHP رو از لاگ بخونید
3. یه تیکت با جزئیات بسازید

---

**موفق باشید! 🚀**
