# 🚀 راهنمای به‌روزرسانی ربات APN

## 📋 خلاصه تغییرات

سلام! ربات شما با موفقیت به‌روزرسانی شد. تمام موارد درخواستی شما پیاده‌سازی شده است:

### ✅ کارهای انجام شده:

#### 1. حذف دکمه "سرویس‌های من" اضافی
- دکمه تکراری `📦 سرویس‌های من` از منوی اصلی حذف شد
- فقط یک دکمه برای سرویس‌ها باقی مانده که همان `سرویس‌های من` در بخش `mySubscriptions` است

#### 2. تغییر VPN به APN
- تمام جاهایی که نوشته بود "VPN" حالا "APN" شده
- در دکمه خرید سرویس: `🔥 خرید سرویس APN`
- در صفحات داخلی هم همینطور

#### 3. نمایش پیام‌ها از پایین
**مشکل قبلی:** وقتی دکمه‌ای میزدید، پیام بالا می‌رفت و دکمه‌های قبلی معلوم نبود

**حل شده:** حالا وقتی هر دکمه‌ای رو می‌زنید:
- پیام قبلی پاک می‌شه
- پیام جدید از پایین میاد
- خیلی راحت‌تر و کاربرپسندتر شده

**صفحاتی که فیکس شدن:**
- خرید سرویس APN
- انتخاب پلن‌ها
- تایید خرید
- پشتیبانی و تیکت‌ها
- اطلاعات کاربری
- سرویس‌های من
- ثبت تیکت

#### 4. فیکس دکمه‌های بازگشت و منصرف شدم
- تمام دکمه‌های بازگشت درست کار می‌کنن
- دیگه گیر نمی‌کنید جایی
- مثلا در ثبت تیکت، دکمه بازگشت به بخش پشتیبانی برمی‌گرده (نه منوی اصلی)

#### 5. جریان کامل خرید و پرداخت 🎉

این بخش خیلی مهمه! حالا جریان خرید کاملا کار می‌کنه:

##### 💰 خرید با کیف پول:
```
1. کاربر: خرید سرویس APN
2. کاربر: انتخاب دسته (مثلا پریمیوم)
3. کاربر: انتخاب پلن (مثلا 50 گیگ یک ماهه)
4. کاربر: پرداخت از کیف پول
5. ربات: چک موجودی
6. ربات: کسر مبلغ
7. ربات: ساخت سرویس (اتوماتیک)
8. ربات: ارسال کانفیگ به کاربر ✅
```

##### 🏦 خرید با فیش بانکی:
```
1. کاربر: خرید سرویس APN
2. کاربر: انتخاب دسته
3. کاربر: انتخاب پلن
4. کاربر: پرداخت فیش بانکی
5. کاربر: آپلود فیش
6. ربات: ارسال فیش به ادمین
7. ادمین: دو گزینه داره:
   
   گزینه 1️⃣ تایید:
   - ربات: ساخت سرویس
   - ربات: ارسال کانفیگ به کاربر
   - کاربر: دریافت کانفیگ + UUID + راهنما ✅
   
   گزینه 2️⃣ رد:
   - ربات: اطلاع به کاربر
   - کاربر: پیام رد پرداخت می‌بینه
   - کاربر: می‌تونه با پشتیبانی تماس بگیره
```

##### 📱 دریافت کانفیگ:
بعد از خرید موفق، کاربر یه پیام دریافت می‌کنه با این اطلاعات:
- نام پلن
- حجم و مدت
- تاریخ انقضا
- UUID کامل
- لینک کانفیگ (اگه موجود باشه)
- دکمه "دریافت کانفیگ" برای مشاهده دوباره
- دکمه "راهنمای اتصال"
- دکمه "تمدید سرویس"

---

## 🔧 نصب و راه‌اندازی

### پیش‌نیاز:
قبل از استفاده، مطمئن شید این جداول در دیتابیس شما وجود دارن:

#### جدول 1: `temp_service_purchases`
این جدول برای نگهداری موقت اطلاعات خرید با فیش بانکیه:

```sql
CREATE TABLE IF NOT EXISTS `temp_service_purchases` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `hash_id` VARCHAR(255) NOT NULL,
    `user_id` INT NOT NULL,
    `plan_id` INT NOT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_hash` (`hash_id`),
    INDEX `idx_user` (`user_id`)
);
```

#### جدول 2: `service_orders`
این جدول تمام سفارشات و سرویس‌های فعال رو نگه می‌داره:

```sql
CREATE TABLE IF NOT EXISTS `service_orders` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `user_id` INT NOT NULL,
    `plan_id` INT NOT NULL,
    `server_id` INT NOT NULL,
    `hash_id` VARCHAR(255),
    `email` VARCHAR(255) NOT NULL,
    `uuid` VARCHAR(255),
    `inbound_id` INT,
    `config_link` TEXT,
    `volume_gb` INT,
    `days` INT,
    `price` INT,
    `expire_date` DATETIME,
    `status` ENUM('active', 'expired', 'suspended') DEFAULT 'active',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_user` (`user_id`),
    INDEX `idx_hash` (`hash_id`),
    INDEX `idx_status` (`status`)
);
```

### نحوه اجرای SQL:
1. به phpMyAdmin یا دیتابیس خودتون برید
2. تب SQL رو باز کنید
3. هر دو کد بالا رو کپی کنید و اجرا کنید
4. اگه پیغام موفقیت اومد، آماده‌اید! ✅

---

## 🧪 تست کردن ربات

### تست 1: نمایش از پایین
```
1. /start بزنید
2. هر دکمه‌ای رو بزنید (مثلا "اطلاعات من")
3. پیام باید از پایین بیاد، نه بالا
4. دکمه‌های قبلی نباید دیده بشن
✅ اگه همینطور شد، درسته!
```

### تست 2: خرید با کیف پول
```
1. اول کیف پول خودتون رو شارژ کنید
2. /start -> خرید سرویس APN
3. یه دسته انتخاب کنید
4. یه پلن انتخاب کنید
5. "پرداخت از کیف پول" رو بزنید
6. باید پیام موفقیت بیاد
7. کانفیگ باید ارسال بشه
✅ اگه کانفیگ اومد، کار درسته!
```

### تست 3: خرید با فیش
```
به عنوان کاربر:
1. /start -> خرید سرویس APN
2. انتخاب دسته و پلن
3. "پرداخت فیش بانکی" رو بزنید
4. یه عکس تستی بفرستید
5. باید پیام "فیش ثبت شد" بیاد

به عنوان ادمین:
6. فیش به ادمین میاد
7. دو دکمه داره: تایید و رد
8. "تایید" رو بزنید
9. سرویس باید ساخته بشه
10. کانفیگ به کاربر فرستاده بشه
✅ اگه کاربر کانفیگ گرفت، عالیه!
```

### تست 4: دکمه‌های بازگشت
```
1. /start
2. تیکت‌های من
3. ثبت تیکت
4. دکمه بازگشت
5. باید به بخش پشتیبانی برگرده (نه منوی اصلی)
✅ اگه برگشت به پشتیبانی، درسته!
```

---

## ⚙️ تنظیمات اضافی

### API سرور VPS:
اگه سرور VPS دارید، این متغیرها رو در `config.php` تنظیم کنید:

```php
define('VPS_API_URL', 'http://IP-SARVER-SHOMA/api/create_vip_account.php');
define('VPS_API_SECRET', 'KELID-AMNIYATI-SHOMA');
```

اگه نداشتید، از تنظیمات پیش‌فرض استفاده میشه.

---

## 📊 لاگ‌ها

تمام عملیات ساخت سرویس در این مسیر لاگ میشه:
```
/logs/service_creation_YYYY-MM-DD.log
```

اگه مشکلی پیش اومد، این فایل رو چک کنید.

---

## 🆘 رفع مشکل

### مشکل 1: کانفیگ ارسال نمیشه
**راه حل:**
- چک کنید جداول ایجاد شدن
- چک کنید API سرور VPS فعاله
- لاگ‌ها رو بررسی کنید

### مشکل 2: پیام‌ها از بالا میان
**راه حل:**
- مطمئن شید فایل‌های `bot.php` و `config.php` آپدیت شدن
- ربات رو ریستارت کنید

### مشکل 3: دکمه بازگشت کار نمیکنه
**راه حل:**
- webhook رو دوباره ست کنید
- کش تلگرام رو پاک کنید

---

## 📞 پشتیبانی

اگه مشکلی داشتید یا سوالی بود، با من تماس بگیرید:

**توسعه‌دهنده:** @NoovixCo  
**تاریخ به‌روزرسانی:** 29 نوامبر 2025

---

## 🎉 خلاصه

✅ دکمه سرویس‌های من اضافی حذف شد  
✅ VPN به APN تغییر کرد  
✅ پیام‌ها از پایین نمایش داده میشن  
✅ دکمه‌های بازگشت درست کار می‌کنن  
✅ جریان خرید کامل و قابل استفاده است  
✅ تایید و رد پرداخت توسط ادمین  
✅ ارسال اتوماتیک کانفیگ  

**ربات شما آماده استفاده است! 🚀**

موفق باشید! 💙
