<?php
// هندلر پلن‌های VIP (بدون نیاز به سرور)

// اگر متغیرهای اصلی تعریف نشدن، از اجرا جلوگیری کن (برای test.php)
if(!isset($data)) $data = '';
if(!isset($text)) $text = '';
if(!isset($from_id)) return;

// پلن‌های VIP با قیمت ثابت
$vipPlans = [
    'vip1' => [
        'name' => '20 گیگ یک ماهه 🌟',
        'volume' => 20,
        'days' => 30,
        'price' => 40000,
        'users' => 1,
        'description' => '⚡️ 20 گیگ - یک ماهه
👤 تک کاربره (فقط 1 دستگاه)
🌍 لوکیشن: آلمان 🇩🇪
🚀 آپتایم 99%
✅ سرور VIP'
    ],
    'vip2' => [
        'name' => '35 گیگ یک ماهه 🌟',
        'volume' => 35,
        'days' => 30,
        'price' => 55000,
        'users' => 1,
        'description' => '⚡️ 35 گیگ - یک ماهه
👤 تک کاربره (فقط 1 دستگاه)
🌍 لوکیشن: آلمان 🇩🇪
🚀 آپتایم 99%
✅ سرور VIP'
    ],
    'vip3' => [
        'name' => '70 گیگ یک ماهه 🔥',
        'volume' => 70,
        'days' => 30,
        'price' => 85000,
        'users' => 1,
        'description' => '⚡️ 70 گیگ - یک ماهه
👤 تک کاربره (فقط 1 دستگاه)
🌍 لوکیشن: آلمان 🇩🇪
🚀 آپتایم 99%
✅ سرور VIP'
    ],
    'vip4' => [
        'name' => '90 گیگ یک ماهه 🔥',
        'volume' => 90,
        'days' => 30,
        'price' => 100000,
        'users' => 1,
        'description' => '⚡️ 90 گیگ - یک ماهه
👤 تک کاربره (فقط 1 دستگاه)
🌍 لوکیشن: آلمان 🇩🇪
🚀 آپتایم 99%
✅ سرور VIP'
    ],
    'vip5' => [
        'name' => '200 گیگ یک ماهه 💎',
        'volume' => 200,
        'days' => 30,
        'price' => 180000,
        'users' => 1,
        'description' => '⚡️ 200 گیگ - یک ماهه
👤 تک کاربره (فقط 1 دستگاه)
🌍 لوکیشن: آلمان 🇩🇪
🚀 آپتایم 99%
✅ سرور VIP'
    ],
    'vip6' => [
        'name' => '300 گیگ یک ماهه 💎',
        'volume' => 300,
        'days' => 30,
        'price' => 250000,
        'users' => 1,
        'description' => '⚡️ 300 گیگ - یک ماهه
👤 تک کاربره (فقط 1 دستگاه)
🌍 لوکیشن: آلمان 🇩🇪
🚀 آپتایم 99%
✅ سرور VIP'
    ],
    'vip7' => [
        'name' => 'نامحدود تک کاربره 👑',
        'volume' => 0,
        'days' => 30,
        'price' => 120000,
        'users' => 1,
        'description' => '♾️ حجم نامحدود - یک ماهه
👤 تک کاربره (فقط 1 دستگاه)
🌍 لوکیشن: آلمان 🇩🇪
🚀 آپتایم 99%
✅ سرور VIP'
    ],
    'vip8' => [
        'name' => 'نامحدود دو کاربره 👑👑',
        'volume' => 0,
        'days' => 30,
        'price' => 280000,
        'users' => 2,
        'description' => '♾️ حجم نامحدود - یک ماهه
👥 دو کاربره (2 دستگاه همزمان)
🌍 لوکیشن: آلمان 🇩🇪
🚀 آپتایم 99%
✅ سرور VIP'
    ],
    'vip9' => [
        'name' => '100 گیگ دو کاربره یک ماهه 💫',
        'volume' => 100,
        'days' => 30,
        'price' => 160000,
        'users' => 2,
        'description' => '⚡️ 100 گیگ - یک ماهه
👥 دو کاربره (2 دستگاه همزمان)
🌍 لوکیشن: آلمان 🇩🇪
🚀 آپتایم 99%
✅ سرور VIP
💡 مناسب خانواده'
    ],
    'vip10' => [
        'name' => '150 گیگ دو کاربره یک ماهه 🌟',
        'volume' => 150,
        'days' => 30,
        'price' => 220000,
        'users' => 2,
        'description' => '⚡️ 150 گیگ - یک ماهه
👥 دو کاربره (2 دستگاه همزمان)
🌍 لوکیشن: آلمان 🇩🇪
🚀 آپتایم 99%
✅ سرور VIP
💡 مناسب خانواده'
    ],
    'vip11' => [
        'name' => '200 گیگ دو کاربره سه ماهه 🔥',
        'volume' => 200,
        'days' => 90,
        'price' => 450000,
        'users' => 2,
        'description' => '⚡️ 200 گیگ - سه ماهه
👥 دو کاربره (2 دستگاه همزمان)
🌍 لوکیشن: آلمان 🇩🇪
🚀 آپتایم 99%
✅ سرور VIP
🎁 صرفه‌جویی 15%
💎 پلن بلند مدت'
    ],
    'vip12' => [
        'name' => 'نامحدود دو کاربره سه ماهه 👑',
        'volume' => 0,
        'days' => 90,
        'price' => 700000,
        'users' => 2,
        'description' => '♾️ حجم نامحدود - سه ماهه
👥 دو کاربره (2 دستگاه همزمان)
🌍 لوکیشن: آلمان 🇩🇪
🚀 آپتایم 99%
✅ سرور VIP
🎁 صرفه‌جویی 17%
💎 بهترین انتخاب'
    ]
];

// چک کردن وضعیت فروش پلن‌های VIP
function isVipPlanEnabled($planKey) {
    global $connection;
    
    $stmt = $connection->prepare("SELECT `enabled` FROM `vip_plans_status` WHERE `plan_key` = ?");
    $stmt->bind_param("s", $planKey);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($row = $result->fetch_assoc()) {
        return $row['enabled'] == 1;
    }
    
    // اگر رکوردی نبود، پیش‌فرض فعال است
    return true;
}

// فیلتر کردن پلن‌های فعال VIP
function getActiveVipPlans() {
    global $vipPlans;
    
    $activePlans = [];
    foreach($vipPlans as $key => $plan) {
        if(isVipPlanEnabled($key)) {
            $activePlans[$key] = $plan;
        }
    }
    
    return $activePlans;
}

// نمایش لیست پلن‌های VIP
if($data == 'vipPlans'){
    // فیلتر کردن پلن‌های فعال
    $activePlans = getActiveVipPlans();
    
    if(empty($activePlans)) {
        delMessage();
        
        $message = "⚠️ <b>در حال حاضر پلن VIP برای فروش موجود نیست</b>

━━━━━━━━━━━━━━━━━━━━━━

🔥 <b>پلن‌های VIP</b>

💹 پلن‌های VIP به زودی موجود خواهند شد.

🔔 برای اطلاع از موجودی با پشتیبانی تماس بگیرید.";
        
        $keyboard = [];
        $keyboard[] = [['text' => '📞 پشتیبانی', 'callback_data' => 'supportSection']];
        $keyboard[] = [['text' => $buttonValues['back_to_main'], 'callback_data' => 'mainMenu']];
        
        sendMessage($message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
        exit;
    }
    
    // ارسال پوستر اگر وجود دارد
    $poster_path = __DIR__ . '/poster.png';
    if(file_exists($poster_path)){
        delMessage();
        Bot('sendPhoto', [
            'chat_id' => $from_id,
            'photo' => new CURLFile($poster_path),
            'caption' => "🔥 فروشگاه تحریم‌شکن APN 🔥"
        ]);
    }
    
    $keyboard = [];
    
    // پلن‌های تک کاربره یک ماهه
    $singleUserPlans = [];
    foreach($activePlans as $key => $plan) {
        if($plan['users'] == 1 && $plan['days'] == 30) {
            $singleUserPlans[$key] = $plan;
        }
    }
    
    if(!empty($singleUserPlans)) {
        $keyboard[] = [['text' => '━━━ 👤 پلن‌های تک کاربره یک ماهه ━━━', 'callback_data' => 'none']];
        
        if(isset($singleUserPlans['vip1']) && isVipPlanEnabled('vip1')) $keyboard[] = [['text' => '⚡️ 20GB - 40,000 تومان', 'callback_data' => 'selectVipPlan_vip1']];
        if(isset($singleUserPlans['vip2']) && isVipPlanEnabled('vip2')) $keyboard[] = [['text' => '⚡️ 35GB - 55,000 تومان', 'callback_data' => 'selectVipPlan_vip2']];
        if(isset($singleUserPlans['vip3']) && isVipPlanEnabled('vip3')) $keyboard[] = [['text' => '⚡️ 70GB - 85,000 تومان', 'callback_data' => 'selectVipPlan_vip3']];
        if(isset($singleUserPlans['vip4']) && isVipPlanEnabled('vip4')) $keyboard[] = [['text' => '⚡️ 90GB - 100,000 تومان', 'callback_data' => 'selectVipPlan_vip4']];
        if(isset($singleUserPlans['vip5']) && isVipPlanEnabled('vip5')) $keyboard[] = [['text' => '⚡️ 200GB - 180,000 تومان', 'callback_data' => 'selectVipPlan_vip5']];
        if(isset($singleUserPlans['vip6']) && isVipPlanEnabled('vip6')) $keyboard[] = [['text' => '⚡️ 300GB - 250,000 تومان', 'callback_data' => 'selectVipPlan_vip6']];
        if(isset($singleUserPlans['vip7']) && isVipPlanEnabled('vip7')) $keyboard[] = [['text' => '♾️ نامحدود - 120,000 تومان', 'callback_data' => 'selectVipPlan_vip7']];
    }
    
    // پلن‌های دو کاربره یک ماهه
    $doubleUserMonthlyPlans = [];
    foreach($activePlans as $key => $plan) {
        if($plan['users'] == 2 && $plan['days'] == 30) {
            $doubleUserMonthlyPlans[$key] = $plan;
        }
    }
    
    if(!empty($doubleUserMonthlyPlans)) {
        $keyboard[] = [['text' => '━━━ 👥 پلن‌های دو کاربره یک ماهه ━━━', 'callback_data' => 'none']];
        
        if(isset($doubleUserMonthlyPlans['vip9']) && isVipPlanEnabled('vip9')) $keyboard[] = [['text' => '💫 100GB - 160,000 تومان', 'callback_data' => 'selectVipPlan_vip9']];
        if(isset($doubleUserMonthlyPlans['vip10']) && isVipPlanEnabled('vip10')) $keyboard[] = [['text' => '🌟 150GB - 220,000 تومان', 'callback_data' => 'selectVipPlan_vip10']];
        if(isset($doubleUserMonthlyPlans['vip8']) && isVipPlanEnabled('vip8')) $keyboard[] = [['text' => '👑 نامحدود - 280,000 تومان', 'callback_data' => 'selectVipPlan_vip8']];
    }
    
    // پلن‌های دو کاربره سه ماهه
    $doubleUserQuarterlyPlans = [];
    foreach($activePlans as $key => $plan) {
        if($plan['users'] == 2 && $plan['days'] == 90) {
            $doubleUserQuarterlyPlans[$key] = $plan;
        }
    }
    
    if(!empty($doubleUserQuarterlyPlans)) {
        $keyboard[] = [['text' => '━━━ 👥 پلن‌های دو کاربره سه ماهه ━━━', 'callback_data' => 'none']];
        
        if(isset($doubleUserQuarterlyPlans['vip11']) && isVipPlanEnabled('vip11')) $keyboard[] = [['text' => '🔥 200GB - 450,000 تومان (15% تخفیف)', 'callback_data' => 'selectVipPlan_vip11']];
        if(isset($doubleUserQuarterlyPlans['vip12']) && isVipPlanEnabled('vip12')) $keyboard[] = [['text' => '💎 نامحدود - 700,000 تومان (17% تخفیف)', 'callback_data' => 'selectVipPlan_vip12']];
    }
    
    $keyboard[] = [['text' => $buttonValues['back_to_main'], 'callback_data' => 'mainMenu']];
    
    $message = "🔥 <b>تعرفه سرویس‌های VIP</b> 🔥

━━━━━━━━━━━━━━━━━━━━━━

✨ <b>ویژگی‌های پلن‌ها:</b>

👤 <b>تک کاربره:</b> فقط 1 دستگاه
👥 <b>دو کاربره:</b> 2 دستگاه همزمان
♾️ <b>نامحدود:</b> بدون محدودیت حجم

━━━━━━━━━━━━━━━━━━━━━━

📱 سازگار با همه دستگاه‌ها:
   • اندروید، آیفون
   • ویندوز، مک، لینوکس
   
📡 سازگار با همه اپراتورها:
   • ایرانسل، همراه اول
   • رایتل، مودم‌های 4G/5G

━━━━━━━━━━━━━━━━━━━━━━

🌍 لوکیشن: آلمان 🇩🇪
🚀 آپتایم: 99%
✅ ضمانت بازگشت وجه
💎 پشتیبانی 24/7

🎁 <b>پلن‌های سه ماهه با تخفیف ویژه!</b>

━━━━━━━━━━━━━━━━━━━━━━

🌟 همه این ها سرور های VIP هستند

یکی از پلن‌ها را انتخاب کنید:";
    
    sendMessage($message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// انتخاب پلن VIP و نمایش جزئیات
if(preg_match('/^selectVipPlan_(.+)$/', $data, $match)){
    $planKey = $match[1];
    
    if(!isset($vipPlans[$planKey])){
        alert("پلن یافت نشد!");
        exit;
    }
    
    // چک کردن دسترسی به پلن
    if(!isVipPlanEnabled($planKey)) {
        alert("⚠️ این پلن در حال حاضر برای فروش در دسترس نیست!");
        exit;
    }
    
    $plan = $vipPlans[$planKey];
    $price_formatted = number_format($plan['price']);
    $users_count = $plan['users'] ?? 1;
    $user_type = $users_count == 1 ? "👤 تک کاربره (فقط 1 دستگاه)" : "👥 {$users_count} کاربره ({$users_count} دستگاه همزمان)";
    
    $message = "📋 جزئیات سرویس:

{$plan['description']}

{$user_type}

💰 قیمت: {$price_formatted} تومان

برای خرید روی دکمه پرداخت کلیک کنید 👇";
    
    $keyboard = [];
    
    if($botState['cartToCartState'] == 'on'){
        $keyboard[] = [['text' => '💳 پرداخت کارت به کارت', 'callback_data' => "vipPayCart_{$planKey}"]];
    }
    
    if($botState['walletState'] == 'on'){
        $userWallet = $userInfo['wallet'];
        if($userWallet >= $plan['price']){
            $keyboard[] = [['text' => "💰 پرداخت با کیف پول ({$userWallet} تومان)", 'callback_data' => "vipPayWallet_{$planKey}"]];
        }
    }
    
    $keyboard[] = [['text' => '🔙 بازگشت', 'callback_data' => 'vipPlans']];
    $keyboard[] = [['text' => $buttonValues['back_to_main'], 'callback_data' => 'mainMenu']];
    
    editText($message_id, $message, json_encode(['inline_keyboard' => $keyboard]));
    exit;
}

// پرداخت کارت به کارت
if(preg_match('/^vipPayCart_(.+)$/', $data, $match)){
    $planKey = $match[1];
    
    if(!isset($vipPlans[$planKey])){
        alert("پلن یافت نشد!");
        exit;
    }
    
    $plan = $vipPlans[$planKey];
    
    // اعمال کد تخفیف (اگر وجود دارد)
    include_once 'discount_system.php';
    $discount_info = applyDiscount($from_id, $plan['price']);
    
    $original_price = $plan['price'];
    $final_price = $discount_info['price'];
    $discount_amount = $discount_info['discount'];
    $discount_code = $discount_info['code'];
    
    // ذخیره اطلاعات در pays
    $hash_id = generateUID();
    $price_formatted = number_format($final_price);
    $original_price_formatted = number_format($original_price);
    
    $users_count = $plan['users'] ?? 1;
    $user_type_short = $users_count == 1 ? 'تک کاربره' : "{$users_count} کاربره";
    $description = "خرید پلن VIP: {$plan['name']} - {$user_type_short}";
    
    // ذخیره با type = VIP_PLAN و plan_id = plan key (مثل vip1, vip2)
    $stmt = $connection->prepare("INSERT INTO `pays` (`hash_id`, `description`, `user_id`, `type`, `plan_id`, `volume`, `day`, `price`, `request_date`, `state`, `agent_count`) VALUES (?, ?, ?, 'VIP_PLAN', ?, ?, ?, ?, ?, 'pending', ?)");
    $stmt->bind_param("ssissiiii", $hash_id, $description, $from_id, $planKey, $plan['volume'], $plan['days'], $final_price, $time, $users_count);
    $stmt->execute();
    $stmt->close();
    
    // ذخیره hash_id برای ادامه فرآیند
    setUser("vipCartPay_{$hash_id}", 'step');
    
    delMessage();
    
    // دریافت شماره کارت از تنظیمات
    $stmt = $connection->prepare("SELECT `value` FROM `setting` WHERE `type`='PAYMENT_KEYS'");
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    $paymentKeys = json_decode($result['value'], true);
    $bankAccount = $paymentKeys['bankAccount'] ?? 'شماره کارت تنظیم نشده';
    $holderName = $paymentKeys['holderName'] ?? 'نام صاحب کارت';
    
    // ساخت پیام با یا بدون تخفیف
    $discount_text = "";
    if($discount_amount > 0) {
        $discount_formatted = number_format($discount_amount);
        $discount_text = "\n━━━━━━━━━━━━━━━━━━━━━━
🎁 <b>تخفیف اعمال شد!</b>

💵 قیمت اصلی: <s>{$original_price_formatted} تومان</s>
🎉 کد تخفیف: <code>{$discount_code}</code>
💰 مبلغ تخفیف: <b>{$discount_formatted} تومان</b>

━━━━━━━━━━━━━━━━━━━━━━";
    }
    
    $message = "♻️ عزیزم یه تصویر از فیش واریزی یا شماره پیگیری - ساعت پرداخت - نام پرداخت کننده رو در یک پیام برام ارسال کن:

🔰 <code>{$bankAccount}</code> - {$holderName}
{$discount_text}

💰 <b>مبلغ قابل پرداخت: {$price_formatted} تومان</b>

📋 پلن: {$plan['name']}

✅ بعد از اینکه پرداختت تایید شد، کانفیگ از طریق همین ربات برات ارسال میشه!";
    
    sendMessage($message, $cancelKey, 'html');
    exit;
}

// دریافت رسید پرداخت
if(preg_match('/^vipCartPay_(.+)$/', $userInfo['step'], $match)){
    if($text == $buttonValues['cancel']){
        setUser('none', 'step');
        sendMessage("❌ خرید لغو شد", getMainKeys());
        exit;
    }
    
    $hash_id = $match[1];
    
    // دریافت اطلاعات سفارش
    $stmt = $connection->prepare("SELECT * FROM `pays` WHERE `hash_id`=? AND `user_id`=?");
    $stmt->bind_param("si", $hash_id, $from_id);
    $stmt->execute();
    $payInfo = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if(!$payInfo){
        sendMessage("❌ سفارش یافت نشد!", getMainKeys());
        setUser('none', 'step');
        exit;
    }
    
    // دریافت عکس، فایل، یا متن رسید
    $file_id = null;
    $file_type = null;
    $caption = '';
    $hasReceipt = false;
    
    if(isset($update->message->photo)){
        // اگر عکس فرستاده
        $photos = $update->message->photo;
        $photo = end($photos);
        $file_id = $photo->file_id;
        $file_type = 'photo';
        $caption = isset($update->message->caption) ? $update->message->caption : 'عکس رسید پرداخت';
        $hasReceipt = true;
    } elseif(isset($update->message->document)){
        // اگر فایل فرستاده (PDF یا غیره)
        $file_id = $update->message->document->file_id;
        $file_type = 'document';
        $caption = isset($update->message->caption) ? $update->message->caption : 'فایل رسید پرداخت';
        $hasReceipt = true;
    } elseif(isset($update->message->video)){
        // اگر ویدیو فرستاده
        $file_id = $update->message->video->file_id;
        $file_type = 'video';
        $caption = isset($update->message->caption) ? $update->message->caption : 'ویدیو رسید پرداخت';
        $hasReceipt = true;
    } elseif(isset($text) && !empty($text) && $text != $buttonValues['cancel']) {
        // اگر متن فرستاده (شماره پیگیری، ساعت، نام و...)
        $caption = $text;
        $file_type = 'text';
        $hasReceipt = true;
    }
    
    if(!$hasReceipt){
        sendMessage("⚠️ لطفا رسید پرداخت خود را ارسال کنید:\n\n📸 عکس رسید\n📄 فایل PDF یا سند\n✍️ یا اطلاعات پرداخت (شماره پیگیری، ساعت، نام پرداخت کننده)", $cancelKey);
        exit;
    }
    
    // ذخیره فیش در دیتابیس
    $stmt = $connection->prepare("UPDATE `pays` SET `fish_photo_id`=?, `fish_type`=?, `fish_caption`=? WHERE `hash_id`=?");
    $stmt->bind_param("ssss", $file_id, $file_type, $caption, $hash_id);
    $stmt->execute();
    $stmt->close();
    
    setUser('none', 'step');
    
    $price_formatted = number_format($payInfo['price']);
    $plan_name = $payInfo['description'];
    $volume = $payInfo['volume'] > 0 ? "{$payInfo['volume']} گیگ" : "نامحدود";
    $days = $payInfo['day'];
    
    // ارسال به ادمین
    $admin_message = "🔥 خرید پلن VIP (کارت به کارت) 🔥

▫️ آیدی کاربر: <code>{$from_id}</code>
👨‍💼 اسم کاربر: <a href='tg://user?id={$from_id}'>{$first_name}</a>
⚡️ نام کاربری: @{$username}
📦 پلن: {$plan_name}
🔋 حجم: {$volume}
⏰ مدت: {$days} روز
💰 مبلغ: {$price_formatted} تومان

📝 اطلاعات پرداخت کاربر:
{$caption}";
    
    $keyboard = json_encode([
        'inline_keyboard' => [
            [
                ['text' => '✅ تایید و ارسال اتوماتیک', 'callback_data' => "acceptAuto{$hash_id}"]
            ],
            [
                ['text' => $buttonValues['approve'], 'callback_data' => "accept{$hash_id}"],
                ['text' => $buttonValues['decline'], 'callback_data' => "decline{$from_id}"]
            ]
        ]
    ]);
    
    // ارسال به ادمین بر اساس نوع فایل
    if($file_type == 'photo'){
        Bot('sendPhoto', [
            'chat_id' => $admin,
            'photo' => $file_id,
            'caption' => $admin_message,
            'parse_mode' => 'html',
            'reply_markup' => $keyboard
        ]);
    } elseif($file_type == 'document'){
        Bot('sendDocument', [
            'chat_id' => $admin,
            'document' => $file_id,
            'caption' => $admin_message,
            'parse_mode' => 'html',
            'reply_markup' => $keyboard
        ]);
    } elseif($file_type == 'video'){
        Bot('sendVideo', [
            'chat_id' => $admin,
            'video' => $file_id,
            'caption' => $admin_message,
            'parse_mode' => 'html',
            'reply_markup' => $keyboard
        ]);
    } else {
        // اگر فقط متن داریم، بدون فایل ارسال کن
        sendMessage($admin_message, $keyboard, 'html', $admin);
    }
    
    // به کاربر اطلاع بده
    sendMessage("🛍 سفارشت با موفقیت ثبت شد.
بعد از تایید، کانفیگ برات ارسال میکنم ... 🥳

🚪 /start", getMainKeys());
    exit;
}

// Handler های قدیمی approveVipPay و rejectVipPay حذف شدند
// اکنون از acceptAuto در bot.php استفاده می‌شود

// رد کردن پرداخت توسط ادمین
if(preg_match('/^rejectVipPay_(.+)$/', $data, $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $hash_id = $match[1];
    
    // دریافت اطلاعات سفارش
    $stmt = $connection->prepare("SELECT * FROM `pays` WHERE `hash_id`=?");
    $stmt->bind_param("s", $hash_id);
    $stmt->execute();
    $payInfo = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if(!$payInfo){
        alert("سفارش یافت نشد!");
        exit;
    }
    
    $user_id = $payInfo['user_id'];
    
    // تغییر وضعیت به رد شده
    $stmt = $connection->prepare("UPDATE `pays` SET `state`='rejected' WHERE `hash_id`=?");
    $stmt->bind_param("s", $hash_id);
    $stmt->execute();
    $stmt->close();
    
    delMessage();
    
    // به کاربر اطلاع بده با دکمه تیکت
    $ticketKeyboard = json_encode(['inline_keyboard'=>[
        [['text'=>"🎫 ثبت تیکت پشتیبانی",'callback_data'=>"supportSection"]],
        [['text'=>$buttonValues['back_to_main'],'callback_data'=>"mainMenu"]]
    ]]);
    
    sendMessage("❌ متاسفانه پرداخت شما تایید نشد.

📞 لطفاً از قسمت «تیکت های من» با پشتیبانی در ارتباط باشید.

� روی دکمه زیر کلیک کنید:", $ticketKeyboard, 'html', $user_id);
    
    // به ادمین اطلاع بده
    sendMessage("✅ سفارش رد شد و به کاربر اطلاع داده شد.", getAdminKeys());
    
    exit;
}

// مشاهده سفارش‌های VIP در پنل ادمین
if($data == 'vipOrdersManagement' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $stmt = $connection->prepare("SELECT * FROM `pays` WHERE `type`='vip' ORDER BY `id` DESC LIMIT 20");
    $stmt->execute();
    $orders = $stmt->get_result();
    $stmt->close();
    
    if($orders->num_rows == 0){
        editText($message_id, "📭 هیچ سفارش VIP ثبت نشده است.", json_encode([
            'inline_keyboard' => [
                [['text' => '🔙 بازگشت', 'callback_data' => 'managePanel']]
            ]
        ]));
        exit;
    }
    
    $pending_count = 0;
    $approved_count = 0;
    $completed_count = 0;
    $rejected_count = 0;
    
    $stmt = $connection->prepare("SELECT `state`, COUNT(*) as `count` FROM `pays` WHERE `type`='vip' GROUP BY `state`");
    $stmt->execute();
    $stats = $stmt->get_result();
    while($stat = $stats->fetch_assoc()){
        if($stat['state'] == 'pending') $pending_count = $stat['count'];
        if($stat['state'] == 'approved') $approved_count = $stat['count'];
        if($stat['state'] == 'completed') $completed_count = $stat['count'];
        if($stat['state'] == 'rejected') $rejected_count = $stat['count'];
    }
    $stmt->close();
    
    $message = "🔥 مدیریت سفارش‌های VIP 🔥

📊 آمار:
⏳ در انتظر تایید: {$pending_count}
✅ تایید شده: {$approved_count}
🎉 تکمیل شده: {$completed_count}
❌ رد شده: {$rejected_count}

📋 آخرین سفارش‌ها:
──────────────────";
    
    $keyboard = [];
    $keyboard[] = [['text' => '⏳ منتظر تایید', 'callback_data' => 'vipFilterPending'], ['text' => '🎉 تکمیل شده', 'callback_data' => 'vipFilterCompleted']];
    $keyboard[] = [['text' => '🔙 بازگشت', 'callback_data' => 'managePanel']];
    
    editText($message_id, $message, json_encode(['inline_keyboard' => $keyboard]));
    exit;
}

// فیلتر سفارش‌های منتظر
if($data == 'vipFilterPending' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $stmt = $connection->prepare("SELECT * FROM `pays` WHERE `type`='vip' AND `state`='pending' ORDER BY `id` DESC LIMIT 10");
    $stmt->execute();
    $orders = $stmt->get_result();
    $stmt->close();
    
    if($orders->num_rows == 0){
        alert("📭 سفارش منتظری وجود ندارد");
        exit;
    }
    
    $message = "⏳ سفارش‌های منتظر تایید:\n\n";
    $num = 1;
    
    while($order = $orders->fetch_assoc()){
        $user_id = $order['user_id'];
        $volume = $order['volume'] > 0 ? "{$order['volume']} GB" : "نامحدود";
        $price = number_format($order['price']);
        $date = date('Y/m/d H:i', $order['request_date']);
        
        $message .= "{$num}. 👤 {$user_id}\n   📦 {$volume} - {$price} تومان\n   📅 {$date}\n\n";
        $num++;
    }
    
    $keyboard = [
        [['text' => '🔙 بازگشت', 'callback_data' => 'vipOrdersManagement']]
    ];
    
    editText($message_id, $message, json_encode(['inline_keyboard' => $keyboard]));
    exit;
}

// پنل مدیریت فروش پلن‌های VIP (فقط ادمین)
if($data == 'manageVipSales' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    delMessage();
    
    $message = "⚙️ <b>مدیریت فروش پلن‌های VIP</b>\n\n━━━━━━━━━━━━━━━━━━━━━━\n\n📊 وضعیت فروش پلن‌ها:\n\n";
    
    foreach($vipPlans as $key => $plan) {
        $enabled = isVipPlanEnabled($key);
        $status = $enabled ? "✅ فعال" : "❌ غیرفعال";
        $message .= "• {$plan['name']}: {$status}\n";
    }
    
    $message .= "\n━━━━━━━━━━━━━━━━━━━━━━\n\n💡 برای تغییر وضعیت، روی پلن مورد نظر کلیک کنید.";
    
    $keyboard = [];
    
    foreach($vipPlans as $key => $plan) {
        $enabled = isVipPlanEnabled($key);
        $icon = $enabled ? "✅" : "❌";
        $keyboard[] = [['text' => "{$icon} {$plan['name']}", 'callback_data' => 'toggleVipPlan_' . $key]];
    }
    
    $keyboard[] = [['text' => '🔙 بازگشت به پنل ادمین', 'callback_data' => 'adminSection']];
    
    sendMessage($message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// تغییر وضعیت فروش پلن VIP (فقط ادمین)
if(preg_match('/^toggleVipPlan_(.+)$/', $data, $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $planKey = $match[1];
    
    if(!isset($vipPlans[$planKey])){
        alert("پلن یافت نشد!");
        exit;
    }
    
    // چک کردن وضعیت فعلی
    $stmt = $connection->prepare("SELECT `enabled` FROM `vip_plans_status` WHERE `plan_key` = ?");
    $stmt->bind_param("s", $planKey);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($row = $result->fetch_assoc()) {
        // تغییر وضعیت
        $newStatus = $row['enabled'] == 1 ? 0 : 1;
        $stmt = $connection->prepare("UPDATE `vip_plans_status` SET `enabled` = ? WHERE `plan_key` = ?");
        $stmt->bind_param("is", $newStatus, $planKey);
        $stmt->execute();
    } else {
        // درج رکورد جدید (پیش‌فرض غیرفعال می‌کنیم)
        $newStatus = 0;
        $stmt = $connection->prepare("INSERT INTO `vip_plans_status` (`plan_key`, `enabled`) VALUES (?, ?)");
        $stmt->bind_param("si", $planKey, $newStatus);
        $stmt->execute();
    }
    
    $statusText = $newStatus == 1 ? "فعال" : "غیرفعال";
    alert("✅ وضعیت پلن {$vipPlans[$planKey]['name']} به {$statusText} تغییر یافت!");
    
    // بازخوانی صفحه مدیریت
    $message = "⚙️ <b>مدیریت فروش پلن‌های VIP</b>\n\n━━━━━━━━━━━━━━━━━━━━━━\n\n📊 وضعیت فروش پلن‌ها:\n\n";
    
    foreach($vipPlans as $key => $plan) {
        $enabled = isVipPlanEnabled($key);
        $status = $enabled ? "✅ فعال" : "❌ غیرفعال";
        $message .= "• {$plan['name']}: {$status}\n";
    }
    
    $message .= "\n━━━━━━━━━━━━━━━━━━━━━━\n\n💡 برای تغییر وضعیت، روی پلن مورد نظر کلیک کنید.";
    
    $keyboard = [];
    
    foreach($vipPlans as $key => $plan) {
        $enabled = isVipPlanEnabled($key);
        $icon = $enabled ? "✅" : "❌";
        $keyboard[] = [['text' => "{$icon} {$plan['name']}", 'callback_data' => 'toggleVipPlan_' . $key]];
    }
    
    $keyboard[] = [['text' => '🔙 بازگشت به پنل ادمین', 'callback_data' => 'adminSection']];
    
    editText($message_id, $message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// فیلتر سفارش‌های تکمیل شده
if($data == 'vipFilterCompleted' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $stmt = $connection->prepare("SELECT * FROM `pays` WHERE `type`='vip' AND `state`='completed' ORDER BY `id` DESC LIMIT 10");
    $stmt->execute();
    $orders = $stmt->get_result();
    $stmt->close();
    
    if($orders->num_rows == 0){
        alert("📭 سفارش تکمیل شده‌ای وجود ندارد");
        exit;
    }
    
    $message = "🎉 سفارش‌های تکمیل شده:\n\n";
    $num = 1;
    
    while($order = $orders->fetch_assoc()){
        $user_id = $order['user_id'];
        $volume = $order['volume'] > 0 ? "{$order['volume']} GB" : "نامحدود";
        $price = number_format($order['price']);
        $date = date('Y/m/d H:i', $order['request_date']);
        
        $message .= "{$num}. 👤 {$user_id}\n   📦 {$volume} - {$price} تومان\n   📅 {$date}\n\n";
        $num++;
    }
    
    $keyboard = [
        [['text' => '🔙 بازگشت', 'callback_data' => 'vipOrdersManagement']]
    ];
    
    editText($message_id, $message, json_encode(['inline_keyboard' => $keyboard]));
    exit;
}

// پنل مدیریت فیش‌های در انتظار تایید (فقط ادمین)
if($data == 'managePendingPayments' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    delMessage();
    
    // شمارش فیش‌های در انتظار
    $stmt = $connection->prepare("SELECT COUNT(*) as count FROM `pays` WHERE `type`='vip' AND `state`='pending'");
    $stmt->execute();
    $pendingCount = $stmt->get_result()->fetch_assoc()['count'];
    $stmt->close();
    
    if($pendingCount == 0) {
        $message = "✅ <b>مدیریت فیش‌های در انتظار</b>

━━━━━━━━━━━━━━━━━━━━━━

📭 هیچ فیش در انتظار تایید وجود ندارد!

همه سفارش‌ها پردازش شده‌اند. ✨";
        
        $keyboard = [
            [['text' => '🔙 بازگشت به پنل ادمین', 'callback_data' => 'adminSection']]
        ];
        
        sendMessage($message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
        exit;
    }
    
    // دریافت فیش‌های در انتظار
    $stmt = $connection->prepare("SELECT * FROM `pays` WHERE `type`='vip' AND `state`='pending' ORDER BY `id` DESC LIMIT 20");
    $stmt->execute();
    $orders = $stmt->get_result();
    $stmt->close();
    
    $message = "💳 <b>مدیریت فیش‌های در انتظار تایید</b>

━━━━━━━━━━━━━━━━━━━━━━

📊 تعداد کل در انتظار: <b>{$pendingCount}</b>

━━━━━━━━━━━━━━━━━━━━━━

لیست فیش‌ها (20 مورد اخیر):

";
    
    $num = 1;
    $keyboard = [];
    
    while($order = $orders->fetch_assoc()){
        $user_id = $order['user_id'];
        $hash_id = $order['hash_id'];
        $volume = $order['volume'] > 0 ? "{$order['volume']}GB" : "♾️ نامحدود";
        $price = number_format($order['price']);
        $date = jdate('Y/m/d H:i', $order['request_date']);
        $day = $order['day'];
        $users = $order['agent_count'] ?? 1;
        
        $planDesc = "{$volume} - {$users} کاربره - {$day} روزه";
        
        $message .= "{$num}. 👤 <code>{$user_id}</code>
   📦 {$planDesc}
   💰 {$price} تومان
   📅 {$date}
";
        
        // اگر فیش دارد، نشون بده
        if(!empty($order['fish_caption'])){
            $message .= "   📝 {$order['fish_caption']}\n";
        }
        
        $message .= "\n";
        
        // دکمه‌های تایید و رد
        $keyboard[] = [
            ['text' => "✅ تایید #{$num}", 'callback_data' => "quickApproveVip_{$hash_id}"],
            ['text' => "❌ رد #{$num}", 'callback_data' => "quickRejectVip_{$hash_id}"]
        ];
        
        // دکمه مشاهده فیش (فقط اگر عکس یا فایل باشد)
        if(!empty($order['fish_photo_id']) && in_array($order['fish_type'], ['photo', 'document', 'video'])){
            $keyboard[] = [
                ['text' => "🔍 مشاهده فیش #{$num}", 'callback_data' => "viewFish_{$hash_id}"]
            ];
        }
        
        $num++;
    }
    
    $message .= "━━━━━━━━━━━━━━━━━━━━━━

💡 برای تایید یا رد هر فیش، روی دکمه مربوطه کلیک کنید.";
    
    $keyboard[] = [['text' => '🔄 بروزرسانی لیست', 'callback_data' => 'managePendingPayments']];
    $keyboard[] = [['text' => '🔙 بازگشت به پنل ادمین', 'callback_data' => 'adminSection']];
    
    sendMessage($message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// تایید سریع فیش (بدون نیاز به ارسال کانفیگ)
if(preg_match('/^quickApproveVip_(.+)$/', $data, $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $hash_id = $match[1];
    
    // دریافت اطلاعات سفارش
    $stmt = $connection->prepare("SELECT * FROM `pays` WHERE `hash_id`=?");
    $stmt->bind_param("s", $hash_id);
    $stmt->execute();
    $payInfo = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if(!$payInfo){
        alert("سفارش یافت نشد!");
        exit;
    }
    
    if($payInfo['state'] != 'pending'){
        alert("⚠️ این سفارش قبلاً پردازش شده است!");
        exit;
    }
    
    $user_id = $payInfo['user_id'];
    
    // تغییر وضعیت به تایید شده
    $stmt = $connection->prepare("UPDATE `pays` SET `state`='approved' WHERE `hash_id`=?");
    $stmt->bind_param("s", $hash_id);
    $stmt->execute();
    $stmt->close();
    
    // تنظیم step برای ادمین
    $stmt = $connection->prepare("UPDATE `users` SET `step`=? WHERE `userid`=?");
    $step_value = "sendVipConfig_{$hash_id}";
    $stmt->bind_param("si", $step_value, $from_id);
    $stmt->execute();
    $stmt->close();
    
    $price_formatted = number_format($payInfo['price']);
    $volume = $payInfo['volume'] > 0 ? "{$payInfo['volume']} گیگ" : "نامحدود";
    $days = $payInfo['day'];
    
    delMessage();
    
    $guide_message = "✅ سفارش تایید شد!

📋 اطلاعات سفارش:
👤 کاربر: <code>{$user_id}</code>
🔋 حجم: {$volume}
⏰ مدت: {$days} روز
💰 مبلغ: {$price_formatted} تومان

━━━━━━━━━━━━━━━━━━━━━━
📝 حالا لینک اشتراک (Subscription Link) را ارسال کنید:

📌 مثال صحیح:
<code>http://apn.lotfischool.ir:2096/sub/APN-pro/rnhopbe5mnbyr2f8</code>

یا لینک کانفیگ تکی:
<code>vless://abc123...</code>

⚠️ فقط لینک را بفرستید، بدون متن اضافه!
━━━━━━━━━━━━━━━━━━━━━━

پس از ارسال:
✅ لینک برای کاربر ارسال می‌شود
✅ به 'سرویس‌های من' کاربر اضافه می‌شود
✅ تاریخ انقضا محاسبه می‌شود";
    
    sendMessage($guide_message, $cancelKey, 'html', $from_id);
    exit;
}

// رد سریع فیش
if(preg_match('/^quickRejectVip_(.+)$/', $data, $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $hash_id = $match[1];
    
    // دریافت اطلاعات سفارش
    $stmt = $connection->prepare("SELECT * FROM `pays` WHERE `hash_id`=?");
    $stmt->bind_param("s", $hash_id);
    $stmt->execute();
    $payInfo = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if(!$payInfo){
        alert("سفارش یافت نشد!");
        exit;
    }
    
    if($payInfo['state'] != 'pending'){
        alert("⚠️ این سفارش قبلاً پردازش شده است!");
        exit;
    }
    
    $user_id = $payInfo['user_id'];
    
    // تغییر وضعیت به رد شده
    $stmt = $connection->prepare("UPDATE `pays` SET `state`='rejected' WHERE `hash_id`=?");
    $stmt->bind_param("s", $hash_id);
    $stmt->execute();
    $stmt->close();
    
    delMessage();
    
    // به کاربر اطلاع بده
    $ticketKeyboard = json_encode(['inline_keyboard'=>[
        [['text'=>"🎫 ثبت تیکت پشتیبانی",'callback_data'=>"supportSection"]],
        [['text'=>$buttonValues['back_to_main'],'callback_data'=>"mainMenu"]]
    ]]);
    
    sendMessage("❌ متاسفانه پرداخت شما تایید نشد.

📞 لطفاً از قسمت «تیکت های من» با پشتیبانی در ارتباط باشید.

👇 روی دکمه زیر کلیک کنید:", $ticketKeyboard, 'html', $user_id);
    
    // به ادمین اطلاع بده
    sendMessage("✅ سفارش رد شد و به کاربر <code>{$user_id}</code> اطلاع داده شد.

🔄 برای بازگشت به لیست فیش‌ها:
/start → پنل ادمین → مدیریت فیش‌های در انتظار", getAdminKeys(), 'HTML');
    
    exit;
}

// مشاهده فیش واریزی
if(preg_match('/^viewFish_(.+)$/', $data, $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $hash_id = $match[1];
    
    // دریافت اطلاعات سفارش
    $stmt = $connection->prepare("SELECT * FROM `pays` WHERE `hash_id`=?");
    $stmt->bind_param("s", $hash_id);
    $stmt->execute();
    $payInfo = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if(!$payInfo){
        alert("سفارش یافت نشد!");
        exit;
    }
    
    $user_id = $payInfo['user_id'];
    $price_formatted = number_format($payInfo['price']);
    $volume = $payInfo['volume'] > 0 ? "{$payInfo['volume']} گیگ" : "نامحدود";
    $days = $payInfo['day'];
    $date = jdate('Y/m/d H:i', $payInfo['request_date']);
    
    $caption = "🔍 <b>فیش واریزی</b>

━━━━━━━━━━━━━━━━━━━━━━
👤 کاربر: <code>{$user_id}</code>
🔋 حجم: {$volume}
⏰ مدت: {$days} روز
💰 مبلغ: {$price_formatted} تومان
📅 تاریخ: {$date}
━━━━━━━━━━━━━━━━━━━━━━

📝 اطلاعات پرداخت:
{$payInfo['fish_caption']}";
    
    $keyboard = json_encode([
        'inline_keyboard' => [
            [
                ['text' => '✅ تایید و ارسال کانفیگ', 'callback_data' => "quickApproveVip_{$hash_id}"],
                ['text' => '❌ رد کردن', 'callback_data' => "quickRejectVip_{$hash_id}"]
            ],
            [
                ['text' => '🔙 بازگشت به لیست', 'callback_data' => 'managePendingPayments']
            ]
        ]
    ]);
    
    // ارسال بر اساس نوع فایل
    if($payInfo['fish_type'] == 'photo' && !empty($payInfo['fish_photo_id'])){
        Bot('sendPhoto', [
            'chat_id' => $from_id,
            'photo' => $payInfo['fish_photo_id'],
            'caption' => $caption,
            'parse_mode' => 'html',
            'reply_markup' => $keyboard
        ]);
    } elseif($payInfo['fish_type'] == 'document' && !empty($payInfo['fish_photo_id'])){
        Bot('sendDocument', [
            'chat_id' => $from_id,
            'document' => $payInfo['fish_photo_id'],
            'caption' => $caption,
            'parse_mode' => 'html',
            'reply_markup' => $keyboard
        ]);
    } elseif($payInfo['fish_type'] == 'video' && !empty($payInfo['fish_photo_id'])){
        Bot('sendVideo', [
            'chat_id' => $from_id,
            'video' => $payInfo['fish_photo_id'],
            'caption' => $caption,
            'parse_mode' => 'html',
            'reply_markup' => $keyboard
        ]);
    } else {
        // اگر فقط متن دارد
        sendMessage($caption, $keyboard, 'html', $from_id);
    }
    
    exit;
}
?>
