<?php
/**
 * Handler دریافت لینک دستی برای VIP پلن‌ها
 * این کد باید قبل از ?> آخر فایل bot.php اضافه بشه
 */

// دریافت لینک کانفیگ دستی برای VIP
if(preg_match('/^sendVipConfigManual_(.+)$/', $userInfo['step'] ?? '', $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    if($text == $buttonValues['cancel']){
        $hash_id = $match[1];
        $stmt = $connection->prepare("UPDATE `pays` SET `state`='pending' WHERE `hash_id`=?");
        $stmt->bind_param("s", $hash_id);
        $stmt->execute();
        $stmt->close();
        
        setUser('none', 'step');
        sendMessage("❌ لغو شد", getAdminKeys());
        exit;
    }
    
    $hash_id = $match[1];
    
    $stmt = $connection->prepare("SELECT * FROM `pays` WHERE `hash_id`=?");
    $stmt->bind_param("s", $hash_id);
    $stmt->execute();
    $payInfo = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if(!$payInfo){
        sendMessage("❌ سفارش یافت نشد!", getAdminKeys());
        setUser('none', 'step');
        exit;
    }
    
    $user_id = $payInfo['user_id'];
    $config_link = trim($text);
    
    if(empty($config_link)){
        sendMessage("⚠️ لینک خالی است!", $cancelKey);
        exit;
    }
    
    if(!preg_match('/^(http|https|vless|vmess|trojan|ss|ssr)/', $config_link)){
        sendMessage("⚠️ لینک نامعتبر است!", $cancelKey);
        exit;
    }
    
    $stmt = $connection->prepare("UPDATE `pays` SET `state`='completed', `payid`=? WHERE `hash_id`=?");
    $stmt->bind_param("ss", $config_link, $hash_id);
    $stmt->execute();
    $stmt->close();
    
    $remark = "VIP_" . substr($hash_id, 0, 8);
    $current_time = time();
    $expire_timestamp = $current_time + ($payInfo['day'] * 86400);
    $token = RandomString(30);
    
    $stmt = $connection->prepare("INSERT INTO `orders_list` (`userid`, `token`, `transid`, `fileid`, `server_id`, `inbound_id`, `remark`, `protocol`, `expire_date`, `link`, `amount`, `status`, `date`, `notif`) VALUES (?, ?, ?, 0, 0, 0, ?, 'vless', ?, ?, ?, 1, ?, 0)");
    $stmt->bind_param("sssisiii", $user_id, $token, $hash_id, $remark, $expire_timestamp, $config_link, $payInfo['price'], $current_time);
    $stmt->execute();
    $stmt->close();
    
    setUser('none', 'step');
    
    $volume = $payInfo['volume'] > 0 ? "{$payInfo['volume']} گیگ" : "نامحدود";
    
    sendMessage("🎉 سفارش شما تایید شد!\n\n🔗 لینک:\n<code>{$config_link}</code>\n\n✅ در 'سرویس‌های من' ذخیره شد", getMainKeys(), 'html', $user_id);
    sendMessage("✅ کانفیگ ارسال شد!\n\n👤 کاربر: {$user_id}", getAdminKeys());
    
    exit;
}
