<?php
/**
 * بروزرسانی جدول pays برای افزودن فیلدهای فیش واریزی
 * این فایل را فقط یک بار اجرا کنید
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<!DOCTYPE html>
<html lang='fa' dir='rtl'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>بروزرسانی جدول Pays</title>
    <style>
        body {
            font-family: Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            margin: 0;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
        }
        h1 {
            color: #667eea;
            text-align: center;
            border-bottom: 3px solid #667eea;
            padding-bottom: 15px;
        }
        .success {
            background: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 8px;
            margin: 10px 0;
            border-left: 5px solid #28a745;
        }
        .error {
            background: #f8d7da;
            color: #721c24;
            padding: 15px;
            border-radius: 8px;
            margin: 10px 0;
            border-left: 5px solid #dc3545;
        }
        .info {
            background: #d1ecf1;
            color: #0c5460;
            padding: 15px;
            border-radius: 8px;
            margin: 10px 0;
            border-left: 5px solid #17a2b8;
        }
        code {
            background: #f4f4f4;
            padding: 3px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
        }
        .btn {
            display: inline-block;
            background: #667eea;
            color: white;
            padding: 12px 24px;
            text-decoration: none;
            border-radius: 8px;
            margin-top: 20px;
            text-align: center;
        }
        .btn:hover {
            background: #5568d3;
        }
    </style>
</head>
<body>
<div class='container'>
    <h1>🔄 بروزرسانی جدول Pays</h1>
";

include "baseInfo.php";

$connection = new mysqli('localhost', $dbUserName, $dbPassword, $dbName);

if($connection->connect_error){
    echo "<div class='error'>❌ خطا در اتصال به دیتابیس: " . $connection->connect_error . "</div>";
    echo "</div></body></html>";
    exit;
}

echo "<div class='success'>✅ اتصال به دیتابیس موفق</div>";

$connection->set_charset("utf8mb4");

// بررسی وجود ستون‌ها
$check_columns = $connection->query("SHOW COLUMNS FROM `pays` LIKE 'fish_photo_id'");

if($check_columns->num_rows > 0){
    echo "<div class='info'>ℹ️ ستون‌های فیش قبلاً اضافه شده‌اند. نیازی به بروزرسانی نیست.</div>";
} else {
    echo "<div class='info'>🔧 در حال افزودن ستون‌های جدید...</div>";
    
    $alterQueries = [
        "ALTER TABLE `pays` ADD COLUMN `fish_photo_id` varchar(500) DEFAULT NULL AFTER `agent_count`",
        "ALTER TABLE `pays` ADD COLUMN `fish_type` varchar(50) DEFAULT NULL AFTER `fish_photo_id`",
        "ALTER TABLE `pays` ADD COLUMN `fish_caption` text DEFAULT NULL AFTER `fish_type`"
    ];
    
    $success = true;
    foreach($alterQueries as $query){
        if($connection->query($query)){
            echo "<div class='success'>✅ ستون با موفقیت اضافه شد</div>";
        } else {
            echo "<div class='error'>❌ خطا: " . $connection->error . "</div>";
            $success = false;
        }
    }
    
    if($success){
        echo "<div class='success'>
            <h2>🎉 بروزرسانی با موفقیت انجام شد!</h2>
            <p>حالا جدول <code>pays</code> دارای فیلدهای زیر است:</p>
            <ul>
                <li><code>fish_photo_id</code>: شناسه فایل تلگرام (عکس، سند، ویدیو)</li>
                <li><code>fish_type</code>: نوع فیش (photo, document, video, text)</li>
                <li><code>fish_caption</code>: متن توضیحات فیش</li>
            </ul>
            
            <h3>✨ قابلیت‌های جدید:</h3>
            <ul>
                <li>ذخیره عکس/فایل فیش واریزی کاربران</li>
                <li>مشاهده فیش در پنل مدیریت</li>
                <li>نمایش اطلاعات پرداخت حتی بعد از کنسل شدن</li>
            </ul>
        </div>";
    }
}

$connection->close();

echo "
    <div style='text-align: center;'>
        <a href='test_features.php' class='btn'>📊 مشاهده وضعیت سیستم</a>
        <a href='/' class='btn'>🏠 صفحه اصلی</a>
    </div>
</div>
</body>
</html>";
?>
