<?php
/**
 * تست مستقیم اتصال به X-UI
 * این فایل رو روی VPS آپلود کن و مستقیم توی مرورگر باز کن
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>X-UI Connection Test</h2>";
echo "<pre>";

// تنظیمات
$panel_url = 'http://127.0.0.1:2083/aHfvIoyNWcxlOfBfje/panel';
$username = 'parisa';
$password = '@230902Parisa';

echo "Testing connection to: $panel_url\n\n";

// تست 1: بررسی دسترسی به پنل
echo "Test 1: Check panel accessibility\n";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $panel_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "❌ Error: $error\n";
} else {
    echo "✅ HTTP Code: $http_code\n";
    if ($http_code == 200) {
        echo "✅ Panel is accessible\n";
    }
}

// تست 2: لاگین به پنل
echo "\n\nTest 2: Login to panel\n";
$login_url = $panel_url . '/login';
$cookie_file = sys_get_temp_dir() . '/xui_test_cookie.txt';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $login_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
    'username' => $username,
    'password' => $password
]));
curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie_file);
curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie_file);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "❌ Error: $error\n";
} else {
    echo "✅ HTTP Code: $http_code\n";
    $result = json_decode($response, true);
    if ($result && isset($result['success']) && $result['success']) {
        echo "✅ Login successful!\n";
        echo "Response: " . json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n";
        
        // تست 3: دریافت لیست inbounds
        echo "\n\nTest 3: Get inbounds list\n";
        $inbounds_url = $panel_url . '/panel/api/inbounds/list';
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $inbounds_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie_file);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        echo "HTTP Code: $http_code\n";
        $result = json_decode($response, true);
        
        if ($result && isset($result['success']) && $result['success']) {
            echo "✅ Inbounds retrieved successfully!\n";
            echo "Total inbounds: " . count($result['obj']) . "\n\n";
            
            foreach ($result['obj'] as $inbound) {
                echo "- ID: {$inbound['id']}, Protocol: {$inbound['protocol']}, Port: {$inbound['port']}, Remark: {$inbound['remark']}\n";
                if (strtolower($inbound['protocol']) === 'vless') {
                    echo "  ✅ Found VLESS inbound!\n";
                }
            }
        } else {
            echo "❌ Failed to get inbounds\n";
            echo "Response: " . json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n";
        }
        
    } else {
        echo "❌ Login failed\n";
        echo "Response: $response\n";
    }
}

// پاک کردن کوکی
if (file_exists($cookie_file)) {
    unlink($cookie_file);
}

echo "\n\n=== Test Completed ===\n";
echo "</pre>";
