<?php
include_once 'config.php';

$plan_id = $_GET['plan_id'] ?? 0;

if(!$plan_id){
    echo "<p style='color:red;'>❌ Plan ID نامعتبر</p>";
    exit;
}

// دریافت اطلاعات پلن
$stmt = $connection->prepare("
    SELECT sp.*, pc.name as category_name, pc.id as category_id, s.name as server_name, s.location 
    FROM service_plans sp 
    JOIN plan_categories pc ON sp.category_id = pc.id 
    JOIN servers s ON sp.server_id = s.id 
    WHERE sp.id = ?
");
$stmt->bind_param("i", $plan_id);
$stmt->execute();
$plan = $stmt->get_result()->fetch_assoc();
$stmt->close();

if(!$plan){
    echo "<p style='color:red;'>❌ پلن یافت نشد! (ID: $plan_id)</p>";
    exit;
}

// چک status
if($plan['status'] != 'active'){
    echo "<p style='color:orange;'>⚠️ پلن غیرفعال است! (status: {$plan['status']})</p>";
}

echo "<h3 style='color:green;'>✅ پلن پیدا شد!</h3>";
echo "<table border='1' cellpadding='8' style='border-collapse:collapse;'>";
echo "<tr><th>فیلد</th><th>مقدار</th></tr>";
echo "<tr><td>ID</td><td>{$plan['id']}</td></tr>";
echo "<tr><td>نام</td><td>{$plan['name']}</td></tr>";
echo "<tr><td>دسته</td><td>{$plan['category_name']} (ID: {$plan['category_id']})</td></tr>";
echo "<tr><td>سرور</td><td>{$plan['server_name']}</td></tr>";
echo "<tr><td>لوکیشن</td><td>{$plan['location']}</td></tr>";
echo "<tr><td>حجم</td><td>" . ($plan['volume_gb'] > 0 ? $plan['volume_gb'] . ' GB' : 'نامحدود') . "</td></tr>";
echo "<tr><td>مدت</td><td>{$plan['days']} روز</td></tr>";
echo "<tr><td>قیمت</td><td>" . number_format($plan['price']) . " تومان</td></tr>";
echo "<tr><td>وضعیت</td><td>{$plan['status']}</td></tr>";
echo "</table>";

echo "<h4>📝 پیام تایید خرید:</h4>";

$volume_text = $plan['volume_gb'] > 0 ? $plan['volume_gb'] . ' گیگابایت' : 'نامحدود';
$price_text = number_format($plan['price']);

if(function_exists('jdate')){
    $expire_shamsi = jdate('Y/m/d', strtotime('+' . $plan['days'] . ' days'));
} else {
    $expire_shamsi = date('Y-m-d', strtotime('+' . $plan['days'] . ' days'));
}

$message = "🛒 تایید خرید\n\n";
$message .= "━━━━━━━━━━━━━━━━━━\n";
$message .= "📦 {$plan['name']}\n";
$message .= "━━━━━━━━━━━━━━━━━━\n\n";
$message .= "📂 دسته: {$plan['category_name']}\n";
$message .= "🖥️ سرور: {$plan['server_name']}\n";
$message .= "🌍 لوکیشن: {$plan['location']}\n";
$message .= "🔋 حجم: {$volume_text}\n";
$message .= "⏰ مدت: {$plan['days']} روز\n";
$message .= "📅 انقضا: {$expire_shamsi}\n\n";
$message .= "💰 مبلغ قابل پرداخت: {$price_text} تومان\n\n";
$message .= "━━━━━━━━━━━━━━━━━━\n";
$message .= "💳 روش پرداخت خود را انتخاب کنید:";

echo "<div style='background:#f5f5f5; padding:15px; border:1px solid #ddd; white-space:pre-wrap; direction:rtl;'>";
echo htmlspecialchars($message);
echo "</div>";

echo "<h4>🔗 Callback Data:</h4>";
echo "<p><code>buyPlan_{$plan['id']}</code></p>";
echo "<p><code>payFromWallet_{$plan['id']}</code></p>";
echo "<p><code>payByReceipt_{$plan['id']}</code></p>";
echo "<p><code>showPlansInCategory_{$plan['category_id']}</code></p>";

echo "<p style='color:green; font-size:16px;'><strong>✅ اگه این اطلاعات درسته، پس کد سمت سرور هم درست کار می‌کنه!</strong></p>";
echo "<p>مشکل احتمالا از Telegram webhook یا کش تلگرام هست.</p>";

echo "<h4>🔧 راه حل:</h4>";
echo "<ol>";
echo "<li><a href='deleteWebhook.php' target='_blank'>حذف Webhook</a></li>";
echo "<li><a href='setWebhook.php' target='_blank'>ست کردن دوباره Webhook</a></li>";
echo "<li>ربات رو از چت حذف کنید و دوباره /start بزنید</li>";
echo "<li>دوباره تست کنید</li>";
echo "</ol>";
?>
