<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🧪 تست ویژگی‌های جدید ربات APN</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            font-size: 2em;
            margin-bottom: 10px;
        }
        .content {
            padding: 30px;
        }
        .test-section {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            border-left: 5px solid #667eea;
        }
        .test-section h2 {
            color: #667eea;
            margin-bottom: 15px;
            font-size: 1.5em;
        }
        .test-item {
            background: white;
            padding: 15px;
            margin-bottom: 10px;
            border-radius: 8px;
            border: 1px solid #e0e0e0;
        }
        .test-item h3 {
            color: #333;
            margin-bottom: 8px;
            font-size: 1.1em;
        }
        .test-item p {
            color: #666;
            line-height: 1.6;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            margin: 5px;
            transition: transform 0.3s;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .status {
            display: inline-block;
            padding: 5px 10px;
            border-radius: 5px;
            font-size: 0.9em;
            font-weight: bold;
        }
        .status.success {
            background: #d4edda;
            color: #155724;
        }
        .status.warning {
            background: #fff3cd;
            color: #856404;
        }
        .code-block {
            background: #2d2d2d;
            color: #f8f8f2;
            padding: 15px;
            border-radius: 8px;
            overflow-x: auto;
            margin: 10px 0;
            font-family: 'Courier New', monospace;
        }
        .feature-list {
            list-style: none;
            padding: 0;
        }
        .feature-list li {
            padding: 10px;
            margin-bottom: 5px;
            background: white;
            border-radius: 5px;
            border-left: 3px solid #28a745;
        }
        .feature-list li::before {
            content: "✅ ";
            margin-left: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🧪 تست ویژگی‌های جدید</h1>
            <p>ربات APN - نسخه 2.0</p>
        </div>

        <div class="content">
            <!-- بخش 1: وضعیت فایل‌ها -->
            <div class="test-section">
                <h2>📦 وضعیت فایل‌ها</h2>
                
                <?php
                $files = [
                    'notification_system.php' => 'سیستم نوتیفیکیشن',
                    'discount_system.php' => 'سیستم کد تخفیف',
                    'advanced_reports.php' => 'گزارش‌دهی پیشرفته',
                    'cron_notifications.php' => 'Cron Job',
                ];
                
                foreach($files as $file => $name) {
                    $exists = file_exists($file);
                    echo '<div class="test-item">';
                    echo '<h3>' . $name . '</h3>';
                    if($exists) {
                        echo '<span class="status success">✅ نصب شده</span>';
                        echo '<p>فایل: <code>' . $file . '</code></p>';
                    } else {
                        echo '<span class="status warning">⚠️ یافت نشد</span>';
                        echo '<p>لطفا فایل <code>' . $file . '</code> را آپلود کنید</p>';
                    }
                    echo '</div>';
                }
                ?>
            </div>

            <!-- بخش 2: تست کانکشن دیتابیس -->
            <div class="test-section">
                <h2>🗄️ تست دیتابیس</h2>
                
                <?php
                if(file_exists('baseInfo.php')) {
                    include_once 'baseInfo.php';
                    
                    $connection = new mysqli('localhost', $dbUserName, $dbPassword, $dbName);
                    
                    echo '<div class="test-item">';
                    echo '<h3>اتصال به دیتابیس</h3>';
                    
                    if($connection->connect_error) {
                        echo '<span class="status warning">❌ خطا</span>';
                        echo '<p>' . $connection->connect_error . '</p>';
                    } else {
                        echo '<span class="status success">✅ موفق</span>';
                        echo '<p>اتصال به دیتابیس برقرار است</p>';
                        
                        // چک جدول discounts
                        $result = $connection->query("SHOW TABLES LIKE 'discounts'");
                        if($result->num_rows > 0) {
                            echo '<p>✅ جدول کدهای تخفیف وجود دارد</p>';
                        } else {
                            echo '<p>⚠️ جدول discounts وجود ندارد - از createTables.php استفاده کنید</p>';
                        }
                        
                        $connection->close();
                    }
                    echo '</div>';
                } else {
                    echo '<div class="test-item">';
                    echo '<span class="status warning">⚠️ فایل baseInfo.php یافت نشد</span>';
                    echo '</div>';
                }
                ?>
            </div>

            <!-- بخش 3: ویژگی‌های نصب شده -->
            <div class="test-section">
                <h2>✨ ویژگی‌های جدید</h2>
                
                <ul class="feature-list">
                    <li>سیستم نوتیفیکیشن خودکار (7، 3، 1 روز قبل از اتمام)</li>
                    <li>پیام خوشامدگویی حرفه‌ای برای کاربران جدید</li>
                    <li>کد تخفیف با مبلغ ثابت یا درصدی</li>
                    <li>محدودیت تاریخ و تعداد استفاده کد تخفیف</li>
                    <li>پنل مدیریت کامل کدهای تخفیف</li>
                    <li>داشبورد آمار پیشرفته (درآمد، کاربران، فروش)</li>
                    <li>نمودار فروش 7 روز اخیر</li>
                    <li>تحلیل رفتار کاربران و CLTV</li>
                    <li>ردیابی عملکرد کدهای تخفیف</li>
                    <li>شناسایی بهترین مشتریان</li>
                </ul>
            </div>

            <!-- بخش 4: راهنمای استفاده -->
            <div class="test-section">
                <h2>📖 راهنمای سریع</h2>
                
                <div class="test-item">
                    <h3>برای ادمین:</h3>
                    <p>1️⃣ وارد ربات شوید و /start بزنید</p>
                    <p>2️⃣ مدیریت ربات ⚙️ را انتخاب کنید</p>
                    <p>3️⃣ دکمه‌های جدید را ببینید:</p>
                    <ul>
                        <li>📊 داشبورد آمار پیشرفته</li>
                        <li>🎁 مدیریت کدهای تخفیف</li>
                    </ul>
                </div>

                <div class="test-item">
                    <h3>برای کاربر:</h3>
                    <p>1️⃣ در منوی اصلی دکمه 🎁 کد تخفیف را ببینید</p>
                    <p>2️⃣ کد تخفیف را وارد کنید (مثلا WELCOME10)</p>
                    <p>3️⃣ سرویس خریداری کنید - تخفیف خودکار اعمال می‌شود</p>
                </div>

                <div class="test-item">
                    <h3>تنظیم Cron Job:</h3>
                    <div class="code-block">
0 */6 * * * /usr/bin/php <?php echo realpath('cron_notifications.php'); ?>
                    </div>
                    <p>یا از طریق URL:</p>
                    <div class="code-block">
<?php echo (isset($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']); ?>/cron_notifications.php?key=YOUR_SECRET_KEY
                    </div>
                </div>
            </div>

            <!-- بخش 5: لینک‌های مفید -->
            <div class="test-section">
                <h2>🔗 لینک‌های مفید</h2>
                
                <a href="INSTALLATION_GUIDE.md" class="btn">📚 راهنمای کامل نصب</a>
                <a href="cron_notifications.php?key=YOUR_KEY" class="btn">🧪 تست Cron Job</a>
                <a href="createTables.php" class="btn">🗄️ ساخت جداول</a>
                <a href="/" class="btn">🏠 صفحه اصلی</a>
            </div>

            <!-- بخش 6: آمار سیستم -->
            <div class="test-section">
                <h2>📊 آمار سیستم</h2>
                
                <?php
                if(file_exists('baseInfo.php')) {
                    include_once 'baseInfo.php';
                    $connection = new mysqli('localhost', $dbUserName, $dbPassword, $dbName);
                    
                    if(!$connection->connect_error) {
                        // تعداد کاربران
                        $users = $connection->query("SELECT COUNT(*) as count FROM `users`")->fetch_assoc()['count'];
                        
                        // تعداد سفارشات
                        $orders = $connection->query("SELECT COUNT(*) as count FROM `pays`")->fetch_assoc()['count'];
                        
                        // کدهای تخفیف فعال
                        $discounts = $connection->query("SELECT COUNT(*) as count FROM `discounts` WHERE `can_use` = 1")->fetch_assoc()['count'];
                        
                        echo '<div class="test-item">';
                        echo '<p>👥 تعداد کاربران: <strong>' . number_format($users) . '</strong></p>';
                        echo '<p>🛍 تعداد سفارشات: <strong>' . number_format($orders) . '</strong></p>';
                        echo '<p>🎁 کدهای تخفیف فعال: <strong>' . $discounts . '</strong></p>';
                        echo '</div>';
                        
                        $connection->close();
                    }
                }
                ?>
            </div>
        </div>
    </div>
</body>
</html>
