<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>🔍 بررسی Syntax فایل‌های جدید</h1><hr>";

$files = [
    'notification_system.php',
    'discount_system.php',
    'advanced_reports.php',
    'trading_plans_handler.php',
    'vip_plans_handler.php'
];

foreach($files as $file) {
    echo "<h2>📄 $file</h2>";
    
    if(!file_exists($file)) {
        echo "❌ فایل وجود ندارد!<br><br>";
        continue;
    }
    
    // چک Syntax
    $output = [];
    $return_var = 0;
    exec("php -l $file 2>&1", $output, $return_var);
    
    if($return_var === 0) {
        echo "✅ Syntax صحیح است<br>";
        
        // تست Include
        try {
            ob_start();
            include_once $file;
            ob_end_clean();
            echo "✅ Include موفق<br>";
        } catch(Exception $e) {
            echo "❌ خطای Include: " . $e->getMessage() . "<br>";
        }
    } else {
        echo "❌ خطای Syntax:<br>";
        echo "<pre style='background:#f8d7da; padding:10px;'>";
        echo htmlspecialchars(implode("\n", $output));
        echo "</pre>";
    }
    
    echo "<br>";
}

echo "<hr>";
echo "<h2>✅ بررسی کامل شد!</h2>";
echo "<p>اگر همه چیز سبز بود، فایل‌ها رو آپلود کن و ربات رو تست کن.</p>";
?>
