<?php
/**
 * فایل تنظیم سرور و اتصال به پنل X-UI
 * این فایل رو یک بار اجرا کنید تا اطلاعات سرور ثبت بشه
 */

require_once 'config.php';
require_once 'xui_api.php';

echo "<!DOCTYPE html>
<html dir='rtl' lang='fa'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>⚙️ تنظیم سرور</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Tahoma, Arial; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 20px; }
        .container { max-width: 900px; margin: 0 auto; background: white; border-radius: 20px; padding: 30px; box-shadow: 0 20px 60px rgba(0,0,0,0.3); }
        h1 { color: #667eea; margin-bottom: 10px; }
        .step { background: #f8f9ff; border-radius: 15px; padding: 20px; margin: 20px 0; border-right: 5px solid #667eea; }
        .success { background: #d4edda; border-right-color: #28a745; color: #155724; }
        .error { background: #f8d7da; border-right-color: #dc3545; color: #721c24; }
        .warning { background: #fff3cd; border-right-color: #ffc107; color: #856404; }
        .code { background: #2d2d2d; color: #f8f8f2; padding: 15px; border-radius: 10px; font-family: 'Courier New', monospace; margin: 10px 0; overflow-x: auto; }
        table { width: 100%; border-collapse: collapse; margin: 15px 0; }
        th, td { padding: 12px; text-align: right; border-bottom: 1px solid #ddd; }
        th { background: #667eea; color: white; }
        .btn { display: inline-block; background: #667eea; color: white; padding: 10px 20px; border-radius: 8px; text-decoration: none; margin: 5px; }
        .btn:hover { background: #5568d3; }
    </style>
</head>
<body>
<div class='container'>";

echo "<h1>⚙️ تنظیم سرور X-UI</h1>";
echo "<p style='color: #666; margin-bottom: 30px;'>مراحل تنظیم و اتصال سرور به ربات</p>";

// مرحله 1: بررسی جدول servers
echo "<div class='step'>";
echo "<h2>📋 مرحله 1: بررسی جدول servers</h2>";

$result = $connection->query("SHOW TABLES LIKE 'servers'");
if($result->num_rows == 0){
    echo "<div class='error'>";
    echo "<h3>❌ جدول servers وجود ندارد!</h3>";
    echo "<p>لطفا ابتدا <code>install_new_system.php</code> را اجرا کنید.</p>";
    echo "</div>";
    echo "</div></div></body></html>";
    exit;
}

echo "<div class='success'><p>✅ جدول servers موجود است</p></div>";

// بررسی رکوردها
$servers = $connection->query("SELECT * FROM servers");
echo "<h3>🖥️ سرورهای موجود: " . $servers->num_rows . "</h3>";

if($servers->num_rows > 0){
    echo "<table>";
    echo "<tr><th>ID</th><th>نام</th><th>IP</th><th>پورت</th><th>وضعیت</th><th>عملیات</th></tr>";
    while($server = $servers->fetch_assoc()){
        $status_badge = $server['status'] == 'active' ? '✅ فعال' : '❌ غیرفعال';
        echo "<tr>";
        echo "<td>{$server['id']}</td>";
        echo "<td>{$server['name']}</td>";
        echo "<td>{$server['server_ip']}</td>";
        echo "<td>{$server['panel_port']}</td>";
        echo "<td>{$status_badge}</td>";
        echo "<td><a href='?test={$server['id']}' class='btn'>🔍 تست</a></td>";
        echo "</tr>";
    }
    echo "</table>";
}

echo "</div>";

// مرحله 2: فرم افزودن سرور جدید
if(!isset($_POST['add_server']) && !isset($_GET['test'])){
    echo "<div class='step'>";
    echo "<h2>➕ مرحله 2: افزودن سرور جدید</h2>";
    echo "<form method='POST'>";
    echo "<table>";
    echo "<tr><td><label>نام سرور:</label></td><td><input type='text' name='name' placeholder='سرور آلمان' required style='width:100%;padding:8px;'></td></tr>";
    echo "<tr><td><label>آی پی سرور:</label></td><td><input type='text' name='server_ip' placeholder='82.115.26.209' required style='width:100%;padding:8px;'></td></tr>";
    echo "<tr><td><label>پورت پنل:</label></td><td><input type='number' name='panel_port' value='2083' required style='width:100%;padding:8px;'></td></tr>";
    echo "<tr><td><label>مسیر پنل:</label></td><td><input type='text' name='panel_path' value='/' placeholder='/' style='width:100%;padding:8px;'></td></tr>";
    echo "<tr><td><label>نام کاربری:</label></td><td><input type='text' name='panel_username' placeholder='admin' required style='width:100%;padding:8px;'></td></tr>";
    echo "<tr><td><label>رمز عبور:</label></td><td><input type='password' name='panel_password' required style='width:100%;padding:8px;'></td></tr>";
    echo "<tr><td><label>پروتکل:</label></td><td><select name='protocol' style='width:100%;padding:8px;'><option value='https'>HTTPS</option><option value='http'>HTTP</option></select></td></tr>";
    echo "<tr><td><label>Inbound ID:</label></td><td><input type='number' name='inbound_id' placeholder='1' style='width:100%;padding:8px;'> <small>(اختیاری - از پنل دریافت می‌شود)</small></td></tr>";
    echo "<tr><td><label>لوکیشن:</label></td><td><input type='text' name='location' placeholder='Germany' style='width:100%;padding:8px;'></td></tr>";
    echo "</table>";
    echo "<button type='submit' name='add_server' class='btn' style='font-size:16px;padding:12px 30px;'>💾 ذخیره و تست اتصال</button>";
    echo "</form>";
    echo "</div>";
}

// مرحله 3: پردازش فرم
if(isset($_POST['add_server'])){
    echo "<div class='step'>";
    echo "<h2>⚙️ مرحله 3: ذخیره و تست اتصال</h2>";
    
    $name = trim($_POST['name']);
    $server_ip = trim($_POST['server_ip']);
    $panel_port = (int)$_POST['panel_port'];
    $panel_path = trim($_POST['panel_path']);
    $panel_username = trim($_POST['panel_username']);
    $panel_password = $_POST['panel_password'];
    $protocol = $_POST['protocol'];
    $inbound_id = !empty($_POST['inbound_id']) ? (int)$_POST['inbound_id'] : null;
    $location = trim($_POST['location']);
    
    // ساخت URL پنل
    $panel_url = $protocol . '://' . $server_ip;
    if($panel_port && $panel_port != 80 && $panel_port != 443){
        $panel_url .= ':' . $panel_port;
    }
    if($panel_path && $panel_path != '/'){
        $panel_url .= rtrim($panel_path, '/');
    }
    
    echo "<div class='code'>URL پنل: {$panel_url}</div>";
    
    // تست اتصال
    echo "<h3>🔌 تست اتصال به پنل...</h3>";
    
    try {
        $xui = new XUI_API($panel_url, $panel_username, $panel_password, true);
        
        if($xui->login()){
            echo "<div class='success'><p>✅ اتصال به پنل موفق!</p></div>";
            
            // دریافت لیست Inbounds
            echo "<h3>📡 دریافت لیست Inbounds...</h3>";
            $inbounds = $xui->getInbounds();
            
            if($inbounds){
                echo "<div class='success'><p>✅ " . count($inbounds) . " Inbound یافت شد</p></div>";
                
                echo "<table>";
                echo "<tr><th>ID</th><th>پروتکل</th><th>پورت</th><th>تعداد کاربر</th></tr>";
                foreach($inbounds as $inb){
                    $settings = json_decode($inb['settings'], true);
                    $client_count = isset($settings['clients']) ? count($settings['clients']) : 0;
                    echo "<tr>";
                    echo "<td>{$inb['id']}</td>";
                    echo "<td>{$inb['protocol']}</td>";
                    echo "<td>{$inb['port']}</td>";
                    echo "<td>{$client_count}</td>";
                    echo "</tr>";
                    
                    // اگر inbound_id تنظیم نشده، اولین VLESS رو انتخاب کن
                    if(!$inbound_id && strtolower($inb['protocol']) === 'vless'){
                        $inbound_id = $inb['id'];
                        echo "<tr><td colspan='4' style='background:#d4edda;color:#155724;'><strong>👆 این Inbound به عنوان پیش‌فرض انتخاب شد</strong></td></tr>";
                    }
                }
                echo "</table>";
                
                // ذخیره در دیتابیس
                $stmt = $connection->prepare("INSERT INTO `servers` 
                    (`name`, `server_ip`, `panel_port`, `panel_path`, `panel_username`, `panel_password`, `protocol`, `inbound_id`, `location`, `status`) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 'active')");
                $stmt->bind_param("ssissssis", $name, $server_ip, $panel_port, $panel_path, $panel_username, $panel_password, $protocol, $inbound_id, $location);
                
                if($stmt->execute()){
                    $server_id = $connection->insert_id;
                    echo "<div class='success'>";
                    echo "<h3>🎉 سرور با موفقیت ذخیره شد!</h3>";
                    echo "<p><strong>ID سرور:</strong> {$server_id}</p>";
                    echo "<p><strong>Inbound ID:</strong> {$inbound_id}</p>";
                    echo "<p>حالا می‌توانید تعرفه‌های جدید با این سرور ایجاد کنید.</p>";
                    echo "<a href='add_sample_data.php' class='btn'>➕ افزودن داده نمونه</a>";
                    echo "<a href='setup_server.php' class='btn'>🔄 افزودن سرور جدید</a>";
                    echo "</div>";
                } else {
                    echo "<div class='error'><p>❌ خطا در ذخیره: " . $stmt->error . "</p></div>";
                }
                $stmt->close();
                
            } else {
                echo "<div class='error'><p>❌ نتوانستیم لیست Inbound ها را دریافت کنیم</p></div>";
            }
            
        } else {
            echo "<div class='error'>";
            echo "<h3>❌ خطا در لاگین به پنل</h3>";
            echo "<p>لطفا موارد زیر را بررسی کنید:</p>";
            echo "<ul>";
            echo "<li>نام کاربری و رمز عبور صحیح باشد</li>";
            echo "<li>آی پی و پورت درست وارد شده باشد</li>";
            echo "<li>پنل در دسترس باشد (با مرورگر تست کنید)</li>";
            echo "<li>فایروال سرور اجازه اتصال بدهد</li>";
            echo "</ul>";
            echo "<p>برای دیباگ دقیق‌تر، فایل <code>xui_api_debug.log</code> را بررسی کنید.</p>";
            echo "</div>";
        }
        
    } catch (Exception $e) {
        echo "<div class='error'>";
        echo "<h3>❌ خطای سیستمی</h3>";
        echo "<p>" . $e->getMessage() . "</p>";
        echo "</div>";
    }
    
    echo "</div>";
}

// تست سرور موجود
if(isset($_GET['test'])){
    $server_id = (int)$_GET['test'];
    
    $stmt = $connection->prepare("SELECT * FROM `servers` WHERE `id` = ?");
    $stmt->bind_param("i", $server_id);
    $stmt->execute();
    $server = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if(!$server){
        echo "<div class='error'><p>❌ سرور یافت نشد!</p></div>";
    } else {
        echo "<div class='step'>";
        echo "<h2>🔍 تست سرور: {$server['name']}</h2>";
        
        $panel_url = $server['protocol'] . '://' . $server['server_ip'];
        if($server['panel_port'] && $server['panel_port'] != 80 && $server['panel_port'] != 443){
            $panel_url .= ':' . $server['panel_port'];
        }
        if($server['panel_path'] && $server['panel_path'] != '/'){
            $panel_url .= rtrim($server['panel_path'], '/');
        }
        
        echo "<div class='code'>";
        echo "URL: {$panel_url}<br>";
        echo "Username: {$server['panel_username']}<br>";
        echo "Inbound ID: {$server['inbound_id']}";
        echo "</div>";
        
        try {
            $xui = new XUI_API($panel_url, $server['panel_username'], $server['panel_password'], true);
            
            if($xui->login()){
                echo "<div class='success'><p>✅ اتصال موفق!</p></div>";
                
                $inbounds = $xui->getInbounds();
                if($inbounds){
                    echo "<h3>📡 لیست Inbounds:</h3>";
                    echo "<table>";
                    echo "<tr><th>ID</th><th>پروتکل</th><th>پورت</th><th>تعداد کاربر</th></tr>";
                    foreach($inbounds as $inb){
                        $settings = json_decode($inb['settings'], true);
                        $client_count = isset($settings['clients']) ? count($settings['clients']) : 0;
                        $highlight = ($inb['id'] == $server['inbound_id']) ? 'background:#d4edda;color:#155724;' : '';
                        echo "<tr style='{$highlight}'>";
                        echo "<td>{$inb['id']}</td>";
                        echo "<td>{$inb['protocol']}</td>";
                        echo "<td>{$inb['port']}</td>";
                        echo "<td>{$client_count}</td>";
                        echo "</tr>";
                    }
                    echo "</table>";
                }
                
            } else {
                echo "<div class='error'><p>❌ خطا در لاگین</p></div>";
            }
            
        } catch (Exception $e) {
            echo "<div class='error'><p>❌ " . $e->getMessage() . "</p></div>";
        }
        
        echo "<a href='setup_server.php' class='btn'>🔙 بازگشت</a>";
        echo "</div>";
    }
}

echo "</div></body></html>";
?>
