<?php
/**
 * اسکریپت نصب اولیه سیستم جدید خرید
 * این فایل رو یک بار اجرا کنید تا جداول و دیتای نمونه ایجاد بشه
 */

require_once 'config.php';

echo "🚀 شروع نصب سیستم جدید خرید...\n\n";

// 1. ایجاد جدول plan_categories
echo "📦 ایجاد جدول plan_categories...\n";
$sql = "CREATE TABLE IF NOT EXISTS `plan_categories` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(100) NOT NULL,
    `emoji` VARCHAR(10) DEFAULT '📦',
    `description` TEXT,
    `sort_order` INT DEFAULT 0,
    `status` ENUM('active', 'inactive') DEFAULT 'active',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if($connection->query($sql)){
    echo "✅ جدول plan_categories ایجاد شد\n\n";
} else {
    echo "❌ خطا: " . $connection->error . "\n\n";
}

// 2. ایجاد جدول service_plans
echo "📋 ایجاد جدول service_plans...\n";
$sql = "CREATE TABLE IF NOT EXISTS `service_plans` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `category_id` INT NOT NULL,
    `server_id` INT NOT NULL,
    `name` VARCHAR(100) NOT NULL,
    `volume_gb` INT DEFAULT 0 COMMENT '0 = نامحدود',
    `days` INT NOT NULL,
    `price` INT NOT NULL,
    `inbound_id` INT,
    `status` ENUM('active', 'inactive') DEFAULT 'active',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`category_id`) REFERENCES `plan_categories`(`id`) ON DELETE CASCADE,
    INDEX `idx_category` (`category_id`),
    INDEX `idx_server` (`server_id`),
    INDEX `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if($connection->query($sql)){
    echo "✅ جدول service_plans ایجاد شد\n\n";
} else {
    echo "❌ خطا: " . $connection->error . "\n\n";
}

// 3. ایجاد جدول service_orders
echo "📝 ایجاد جدول service_orders...\n";
$sql = "CREATE TABLE IF NOT EXISTS `service_orders` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `user_id` INT NOT NULL,
    `plan_id` INT NOT NULL,
    `server_id` INT NOT NULL,
    `hash_id` VARCHAR(255),
    `email` VARCHAR(255) NOT NULL,
    `uuid` VARCHAR(255),
    `inbound_id` INT,
    `config_link` TEXT,
    `volume_gb` INT,
    `days` INT,
    `price` INT,
    `expire_date` DATETIME,
    `status` ENUM('active', 'expired', 'suspended') DEFAULT 'active',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_user` (`user_id`),
    INDEX `idx_hash` (`hash_id`),
    INDEX `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if($connection->query($sql)){
    echo "✅ جدول service_orders ایجاد شد\n\n";
} else {
    echo "❌ خطا: " . $connection->error . "\n\n";
}

// 4. ایجاد جدول temp_service_purchases
echo "⏳ ایجاد جدول temp_service_purchases...\n";
$sql = "CREATE TABLE IF NOT EXISTS `temp_service_purchases` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `hash_id` VARCHAR(255) NOT NULL,
    `user_id` INT NOT NULL,
    `plan_id` INT NOT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_hash` (`hash_id`),
    INDEX `idx_user` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if($connection->query($sql)){
    echo "✅ جدول temp_service_purchases ایجاد شد\n\n";
} else {
    echo "❌ خطا: " . $connection->error . "\n\n";
}

// 5. بررسی اینکه آیا دسته‌بندی وجود داره
$stmt = $connection->prepare("SELECT COUNT(*) as count FROM `plan_categories`");
$stmt->execute();
$result = $stmt->get_result()->fetch_assoc();
$stmt->close();

if($result['count'] == 0){
    echo "📦 هیچ دسته‌بندی وجود نداره. ایجاد دسته‌های نمونه...\n";
    
    // ایجاد دسته‌های نمونه
    $categories = [
        ['name' => 'پریمیوم', 'emoji' => '⭐', 'sort_order' => 1],
        ['name' => 'استاندارد', 'emoji' => '📦', 'sort_order' => 2],
        ['name' => 'اقتصادی', 'emoji' => '💰', 'sort_order' => 3]
    ];
    
    foreach($categories as $cat){
        $stmt = $connection->prepare("INSERT INTO `plan_categories` (`name`, `emoji`, `sort_order`, `status`) VALUES (?, ?, ?, 'active')");
        $stmt->bind_param("ssi", $cat['name'], $cat['emoji'], $cat['sort_order']);
        $stmt->execute();
        $stmt->close();
        echo "   ✅ دسته '{$cat['name']}' اضافه شد\n";
    }
    echo "\n";
} else {
    echo "✅ {$result['count']} دسته‌بندی موجود است\n\n";
}

// 6. بررسی اینکه آیا سرور وجود داره
$stmt = $connection->prepare("SELECT COUNT(*) as count FROM `servers`");
$stmt->execute();
$result = $stmt->get_result()->fetch_assoc();
$stmt->close();

if($result['count'] == 0){
    echo "⚠️ هیچ سروری تعریف نشده! برای ایجاد پلن‌ها باید اول سرور اضافه کنید.\n";
    echo "   از بخش مدیریت ربات > مدیریت سرورها، سرور اضافه کنید.\n\n";
} else {
    echo "✅ {$result['count']} سرور موجود است\n\n";
    
    // اگه سرور داریم ولی پلن نداریم، پلن نمونه بسازیم
    $stmt = $connection->prepare("SELECT COUNT(*) as count FROM `service_plans`");
    $stmt->execute();
    $plan_count = $stmt->get_result()->fetch_assoc()['count'];
    $stmt->close();
    
    if($plan_count == 0){
        echo "📋 هیچ پلنی وجود نداره. ایجاد پلن‌های نمونه...\n";
        
        // دریافت اولین سرور
        $stmt = $connection->prepare("SELECT * FROM `servers` WHERE `status`='active' LIMIT 1");
        $stmt->execute();
        $server = $stmt->get_result()->fetch_assoc();
        $stmt->close();
        
        if($server){
            // دریافت دسته پریمیوم
            $stmt = $connection->prepare("SELECT * FROM `plan_categories` WHERE `name`='پریمیوم' LIMIT 1");
            $stmt->execute();
            $category = $stmt->get_result()->fetch_assoc();
            $stmt->close();
            
            if($category){
                // ایجاد پلن‌های نمونه
                $plans = [
                    ['name' => '30GB یک ماهه', 'volume' => 30, 'days' => 30, 'price' => 50000],
                    ['name' => '50GB یک ماهه', 'volume' => 50, 'days' => 30, 'price' => 80000],
                    ['name' => '100GB یک ماهه', 'volume' => 100, 'days' => 30, 'price' => 150000],
                    ['name' => 'نامحدود یک ماهه', 'volume' => 0, 'days' => 30, 'price' => 200000]
                ];
                
                foreach($plans as $plan){
                    $stmt = $connection->prepare("INSERT INTO `service_plans` 
                        (`category_id`, `server_id`, `name`, `volume_gb`, `days`, `price`, `status`) 
                        VALUES (?, ?, ?, ?, ?, ?, 'active')");
                    $stmt->bind_param("iisiii", 
                        $category['id'], 
                        $server['id'], 
                        $plan['name'], 
                        $plan['volume'], 
                        $plan['days'], 
                        $plan['price']
                    );
                    $stmt->execute();
                    $stmt->close();
                    echo "   ✅ پلن '{$plan['name']}' اضافه شد (قیمت: " . number_format($plan['price']) . " تومان)\n";
                }
                echo "\n";
            }
        } else {
            echo "   ⚠️ سرور فعالی وجود نداره. اول سرور اضافه کنید.\n\n";
        }
    } else {
        echo "✅ {$plan_count} پلن موجود است\n\n";
    }
}

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "✅ نصب کامل شد!\n\n";

echo "🔍 خلاصه:\n";
$stmt = $connection->prepare("SELECT COUNT(*) as count FROM `plan_categories` WHERE `status`='active'");
$stmt->execute();
$cat_count = $stmt->get_result()->fetch_assoc()['count'];
$stmt->close();

$stmt = $connection->prepare("SELECT COUNT(*) as count FROM `service_plans` WHERE `status`='active'");
$stmt->execute();
$plan_count = $stmt->get_result()->fetch_assoc()['count'];
$stmt->close();

$stmt = $connection->prepare("SELECT COUNT(*) as count FROM `servers` WHERE `status`='active'");
$stmt->execute();
$server_count = $stmt->get_result()->fetch_assoc()['count'];
$stmt->close();

echo "   📦 دسته‌بندی‌های فعال: {$cat_count}\n";
echo "   📋 پلن‌های فعال: {$plan_count}\n";
echo "   🖥️ سرورهای فعال: {$server_count}\n\n";

if($cat_count > 0 && $plan_count > 0 && $server_count > 0){
    echo "🎉 سیستم خرید آماده استفاده است!\n";
    echo "   برای تست: /start -> خرید سرویس APN\n\n";
} else {
    echo "⚠️ توجه:\n";
    if($cat_count == 0) echo "   - دسته‌بندی اضافه کنید\n";
    if($server_count == 0) echo "   - سرور اضافه کنید (مدیریت ربات > مدیریت سرورها)\n";
    if($plan_count == 0) echo "   - پلن اضافه کنید (مدیریت ربات > مدیریت تعرفه‌ها)\n";
    echo "\n";
}

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
?>
