<?php
/**
 * سیستم مدیریت سرورها
 * مدیریت کامل سرورها، دسته‌بندی‌ها و تعرفه‌ها
 */

// اگر متغیرهای اصلی تعریف نشدن، از اجرا جلوگیری کن
if(!isset($data)) $data = '';
if(!isset($text)) $text = '';
if(!isset($from_id)) return;

// ==================== مدیریت سرورها ====================

// نمایش لیست سرورها
if($data == 'manageServers' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $stmt = $connection->prepare("SELECT * FROM `servers` ORDER BY `id` DESC");
    $stmt->execute();
    $servers = $stmt->get_result();
    $stmt->close();
    
    $message = "🖥️ <b>مدیریت سرورها</b>\n\n";
    
    if($servers->num_rows > 0){
        while($server = $servers->fetch_assoc()){
            $status_icon = $server['status'] == 'active' ? '✅' : '❌';
            $message .= "━━━━━━━━━━━━━━━━━━\n";
            $message .= "{$status_icon} <b>{$server['name']}</b>\n";
            $message .= "🌍 {$server['location']}\n";
            $message .= "📡 IP: <code>{$server['server_ip']}</code>\n";
            $message .= "🔌 پورت: {$server['panel_port']}\n";
            $message .= "━━━━━━━━━━━━━━━━━━\n\n";
        }
    } else {
        $message .= "📭 هیچ سروری ثبت نشده است.\n\n";
    }
    
    $keyboard = [
        [['text' => '➕ افزودن سرور جدید', 'callback_data' => 'addNewServer']],
        [['text' => '📋 لیست سرورها', 'callback_data' => 'listServers']],
        [['text' => '🔙 بازگشت', 'callback_data' => 'adminSection']]
    ];
    
    editText($message_id, $message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// شروع افزودن سرور جدید
if($data == 'addNewServer' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    delMessage();
    
    setUser('addServer_step1_name', 'step');
    
    sendMessage("➕ <b>افزودن سرور جدید</b>\n\n🏷️ نام سرور را وارد کنید:\n\nمثال: <code>سرور آلمان VIP 🇩🇪</code>", $cancelKey, 'HTML');
    exit;
}

// دریافت نام سرور
if($userInfo['step'] == 'addServer_step1_name' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    if($text == $buttonValues['cancel']){
        setUser('none', 'step');
        sendMessage("❌ لغو شد", getAdminKeys());
        exit;
    }
    
    setUser('addServer_step2_ip|' . $text, 'step');
    sendMessage("📡 IP سرور را وارد کنید:\n\nمثال: <code>82.115.26.209</code>", $cancelKey, 'HTML');
    exit;
}

// دریافت IP سرور
if(preg_match('/^addServer_step2_ip\|(.+)$/', $userInfo['step'], $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    if($text == $buttonValues['cancel']){
        setUser('none', 'step');
        sendMessage("❌ لغو شد", getAdminKeys());
        exit;
    }
    
    $server_name = $match[1];
    setUser('addServer_step3_port|' . $server_name . '|' . $text, 'step');
    sendMessage("🔌 پورت پنل را وارد کنید:\n\nمثال: <code>2083</code>", $cancelKey, 'HTML');
    exit;
}

// دریافت پورت
if(preg_match('/^addServer_step3_port\|(.+)\|(.+)$/', $userInfo['step'], $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    if($text == $buttonValues['cancel']){
        setUser('none', 'step');
        sendMessage("❌ لغو شد", getAdminKeys());
        exit;
    }
    
    if(!is_numeric($text)){
        sendMessage("⚠️ پورت باید عدد باشد!", $cancelKey);
        exit;
    }
    
    $server_name = $match[1];
    $server_ip = $match[2];
    setUser('addServer_step4_path|' . $server_name . '|' . $server_ip . '|' . $text, 'step');
    sendMessage("📁 مسیر پنل را وارد کنید:\n\nمثال: <code>/aHfvIoyNWcxlOfBfje</code>\n\nاگر ندارید فقط <code>/</code> بفرستید", $cancelKey, 'HTML');
    exit;
}

// دریافت مسیر پنل
if(preg_match('/^addServer_step4_path\|(.+)\|(.+)\|(.+)$/', $userInfo['step'], $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    if($text == $buttonValues['cancel']){
        setUser('none', 'step');
        sendMessage("❌ لغو شد", getAdminKeys());
        exit;
    }
    
    $server_name = $match[1];
    $server_ip = $match[2];
    $port = $match[3];
    setUser('addServer_step5_username|' . $server_name . '|' . $server_ip . '|' . $port . '|' . $text, 'step');
    sendMessage("👤 نام کاربری پنل را وارد کنید:\n\nمثال: <code>admin</code>", $cancelKey, 'HTML');
    exit;
}

// دریافت نام کاربری
if(preg_match('/^addServer_step5_username\|(.+)\|(.+)\|(.+)\|(.+)$/', $userInfo['step'], $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    if($text == $buttonValues['cancel']){
        setUser('none', 'step');
        sendMessage("❌ لغو شد", getAdminKeys());
        exit;
    }
    
    $server_name = $match[1];
    $server_ip = $match[2];
    $port = $match[3];
    $path = $match[4];
    setUser('addServer_step6_password|' . $server_name . '|' . $server_ip . '|' . $port . '|' . $path . '|' . $text, 'step');
    sendMessage("🔐 رمز عبور پنل را وارد کنید:", $cancelKey, 'HTML');
    exit;
}

// دریافت رمز عبور و ثبت نهایی
if(preg_match('/^addServer_step6_password\|(.+)\|(.+)\|(.+)\|(.+)\|(.+)$/', $userInfo['step'], $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    if($text == $buttonValues['cancel']){
        setUser('none', 'step');
        sendMessage("❌ لغو شد", getAdminKeys());
        exit;
    }
    
    $server_name = $match[1];
    $server_ip = $match[2];
    $port = $match[3];
    $path = $match[4];
    $username = $match[5];
    $password = $text;
    
    // ذخیره در دیتابیس
    $stmt = $connection->prepare("INSERT INTO `servers` (`name`, `server_ip`, `panel_port`, `panel_path`, `panel_username`, `panel_password`, `protocol`, `status`) VALUES (?, ?, ?, ?, ?, ?, 'https', 'active')");
    $stmt->bind_param("ssisss", $server_name, $server_ip, $port, $path, $username, $password);
    
    if($stmt->execute()){
        $server_id = $connection->insert_id;
        setUser('none', 'step');
        
        sendMessage("✅ سرور با موفقیت اضافه شد!\n\n🆔 شناسه: #{$server_id}\n🏷️ نام: {$server_name}\n📡 IP: {$server_ip}", getAdminKeys(), 'HTML');
    } else {
        sendMessage("❌ خطا در ثبت سرور: " . $stmt->error, getAdminKeys());
    }
    $stmt->close();
    exit;
}

// ==================== مدیریت دسته‌بندی‌ها ====================

if($data == 'manageCategories' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $stmt = $connection->prepare("SELECT * FROM `plan_categories` ORDER BY `sort_order` ASC");
    $stmt->execute();
    $categories = $stmt->get_result();
    $stmt->close();
    
    $message = "📦 <b>مدیریت دسته‌بندی‌ها</b>\n\n";
    
    if($categories->num_rows > 0){
        while($cat = $categories->fetch_assoc()){
            $status_icon = $cat['status'] == 'active' ? '✅' : '❌';
            $message .= "{$status_icon} {$cat['emoji']} <b>{$cat['name']}</b>\n";
        }
    } else {
        $message .= "📭 هیچ دسته‌ای ثبت نشده است.\n";
    }
    
    $keyboard = [
        [['text' => '➕ افزودن دسته جدید', 'callback_data' => 'addNewCategory']],
        [['text' => '🔙 بازگشت', 'callback_data' => 'adminSection']]
    ];
    
    editText($message_id, $message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// افزودن دسته جدید
if($data == 'addNewCategory' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    delMessage();
    setUser('addCategory_name', 'step');
    sendMessage("➕ <b>افزودن دسته جدید</b>\n\n🏷️ نام دسته را وارد کنید:\n\nمثال: <code>پلن‌های یک ماهه 📅</code>", $cancelKey, 'HTML');
    exit;
}

// دریافت نام دسته
if($userInfo['step'] == 'addCategory_name' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    if($text == $buttonValues['cancel']){
        setUser('none', 'step');
        sendMessage("❌ لغو شد", getAdminKeys());
        exit;
    }
    
    // استخراج ایموجی از متن
    preg_match('/[\x{1F300}-\x{1F9FF}]/u', $text, $emoji_match);
    $emoji = $emoji_match[0] ?? '📦';
    
    $stmt = $connection->prepare("SELECT MAX(sort_order) as max_order FROM `plan_categories`");
    $stmt->execute();
    $max_order = $stmt->get_result()->fetch_assoc()['max_order'] ?? 0;
    $stmt->close();
    
    $new_order = $max_order + 1;
    
    $stmt = $connection->prepare("INSERT INTO `plan_categories` (`name`, `emoji`, `sort_order`, `status`) VALUES (?, ?, ?, 'active')");
    $stmt->bind_param("ssi", $text, $emoji, $new_order);
    
    if($stmt->execute()){
        setUser('none', 'step');
        sendMessage("✅ دسته '{$text}' با موفقیت اضافه شد!", getAdminKeys(), 'HTML');
    } else {
        sendMessage("❌ خطا: " . $stmt->error, getAdminKeys());
    }
    $stmt->close();
    exit;
}

// ==================== مدیریت تعرفه‌ها ====================

if($data == 'managePlans' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $stmt = $connection->prepare("SELECT sp.*, pc.name as category_name, s.name as server_name FROM `service_plans` sp LEFT JOIN `plan_categories` pc ON sp.category_id = pc.id LEFT JOIN `servers` s ON sp.server_id = s.id ORDER BY sp.id DESC LIMIT 10");
    $stmt->execute();
    $plans = $stmt->get_result();
    $stmt->close();
    
    $message = "🎁 <b>مدیریت تعرفه‌ها</b>\n\n";
    
    if($plans->num_rows > 0){
        while($plan = $plans->fetch_assoc()){
            $status_icon = $plan['status'] == 'active' ? '✅' : '❌';
            $volume = $plan['volume_gb'] > 0 ? $plan['volume_gb'] . ' گیگ' : 'نامحدود';
            $price = number_format($plan['price']);
            
            $message .= "━━━━━━━━━━━━━━━━━━\n";
            $message .= "{$status_icon} <b>{$plan['name']}</b>\n";
            $message .= "📦 دسته: {$plan['category_name']}\n";
            $message .= "🖥️ سرور: {$plan['server_name']}\n";
            $message .= "🔋 حجم: {$volume}\n";
            $message .= "⏰ مدت: {$plan['days']} روز\n";
            $message .= "💰 قیمت: {$price} تومان\n";
            $message .= "━━━━━━━━━━━━━━━━━━\n\n";
        }
    } else {
        $message .= "📭 هیچ تعرفه‌ای ثبت نشده است.\n";
    }
    
    $keyboard = [
        [['text' => '➕ افزودن تعرفه جدید', 'callback_data' => 'addNewPlan']],
        [['text' => '🔙 بازگشت', 'callback_data' => 'adminSection']]
    ];
    
    editText($message_id, $message, json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// شروع افزودن تعرفه
if($data == 'addNewPlan' && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    // دریافت لیست دسته‌بندی‌ها
    $stmt = $connection->prepare("SELECT * FROM `plan_categories` WHERE `status`='active' ORDER BY `sort_order`");
    $stmt->execute();
    $categories = $stmt->get_result();
    $stmt->close();
    
    if($categories->num_rows == 0){
        alert("ابتدا باید دسته‌بندی ایجاد کنید!");
        exit;
    }
    
    delMessage();
    
    $keyboard = [];
    while($cat = $categories->fetch_assoc()){
        $keyboard[] = [['text' => "{$cat['emoji']} {$cat['name']}", 'callback_data' => "selectCategoryForPlan_{$cat['id']}"]];
    }
    $keyboard[] = [['text' => '🔙 انصراف', 'callback_data' => 'managePlans']];
    
    sendMessage("➕ <b>افزودن تعرفه جدید</b>\n\n📦 دسته‌بندی را انتخاب کنید:", json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// انتخاب دسته برای تعرفه
if(preg_match('/^selectCategoryForPlan_(\d+)$/', $data, $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $category_id = $match[1];
    
    // دریافت لیست سرورها
    $stmt = $connection->prepare("SELECT * FROM `servers` WHERE `status`='active'");
    $stmt->execute();
    $servers = $stmt->get_result();
    $stmt->close();
    
    if($servers->num_rows == 0){
        alert("ابتدا باید سرور اضافه کنید!");
        exit;
    }
    
    delMessage();
    
    $keyboard = [];
    while($server = $servers->fetch_assoc()){
        $keyboard[] = [['text' => "🖥️ {$server['name']}", 'callback_data' => "selectServerForPlan_{$category_id}_{$server['id']}"]];
    }
    $keyboard[] = [['text' => '🔙 بازگشت', 'callback_data' => 'addNewPlan']];
    
    sendMessage("🖥️ سرور را انتخاب کنید:", json_encode(['inline_keyboard' => $keyboard]), 'HTML');
    exit;
}

// انتخاب سرور و شروع فرم
if(preg_match('/^selectServerForPlan_(\d+)_(\d+)$/', $data, $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    $category_id = $match[1];
    $server_id = $match[2];
    
    delMessage();
    setUser("addPlan_step1_name|{$category_id}|{$server_id}", 'step');
    sendMessage("🏷️ نام تعرفه را وارد کنید:\n\nمثال: <code>50 گیگ یک ماهه 💎</code>", $cancelKey, 'HTML');
    exit;
}

// دریافت نام تعرفه
if(preg_match('/^addPlan_step1_name\|(\d+)\|(\d+)$/', $userInfo['step'], $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    if($text == $buttonValues['cancel']){
        setUser('none', 'step');
        sendMessage("❌ لغو شد", getAdminKeys());
        exit;
    }
    
    $category_id = $match[1];
    $server_id = $match[2];
    setUser("addPlan_step2_volume|{$category_id}|{$server_id}|{$text}", 'step');
    sendMessage("🔋 حجم به گیگابایت وارد کنید:\n\nبرای نامحدود عدد <code>0</code> را وارد کنید\nمثال: <code>50</code>", $cancelKey, 'HTML');
    exit;
}

// دریافت حجم
if(preg_match('/^addPlan_step2_volume\|(\d+)\|(\d+)\|(.+)$/', $userInfo['step'], $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    if($text == $buttonValues['cancel']){
        setUser('none', 'step');
        sendMessage("❌ لغو شد", getAdminKeys());
        exit;
    }
    
    if(!is_numeric($text)){
        sendMessage("⚠️ حجم باید عدد باشد!", $cancelKey);
        exit;
    }
    
    $category_id = $match[1];
    $server_id = $match[2];
    $plan_name = $match[3];
    setUser("addPlan_step3_days|{$category_id}|{$server_id}|{$plan_name}|{$text}", 'step');
    sendMessage("⏰ مدت زمان به روز وارد کنید:\n\nمثال برای یک ماه: <code>30</code>\nمثال برای سه ماه: <code>90</code>", $cancelKey, 'HTML');
    exit;
}

// دریافت مدت زمان
if(preg_match('/^addPlan_step3_days\|(\d+)\|(\d+)\|(.+)\|(.+)$/', $userInfo['step'], $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    if($text == $buttonValues['cancel']){
        setUser('none', 'step');
        sendMessage("❌ لغو شد", getAdminKeys());
        exit;
    }
    
    if(!is_numeric($text)){
        sendMessage("⚠️ تعداد روز باید عدد باشد!", $cancelKey);
        exit;
    }
    
    $category_id = $match[1];
    $server_id = $match[2];
    $plan_name = $match[3];
    $volume = $match[4];
    setUser("addPlan_step4_price|{$category_id}|{$server_id}|{$plan_name}|{$volume}|{$text}", 'step');
    sendMessage("💰 قیمت به تومان وارد کنید:\n\nمثال: <code>70000</code>", $cancelKey, 'HTML');
    exit;
}

// دریافت قیمت و ثبت تعرفه
if(preg_match('/^addPlan_step4_price\|(\d+)\|(\d+)\|(.+)\|(.+)\|(.+)$/', $userInfo['step'], $match) && ($from_id == $admin || $userInfo['isAdmin'] == true)){
    if($text == $buttonValues['cancel']){
        setUser('none', 'step');
        sendMessage("❌ لغو شد", getAdminKeys());
        exit;
    }
    
    if(!is_numeric($text)){
        sendMessage("⚠️ قیمت باید عدد باشد!", $cancelKey);
        exit;
    }
    
    $category_id = $match[1];
    $server_id = $match[2];
    $plan_name = $match[3];
    $volume = $match[4];
    $days = $match[5];
    $price = $text;
    
    // ثبت در دیتابیس
    $stmt = $connection->prepare("INSERT INTO `service_plans` (`category_id`, `server_id`, `name`, `volume_gb`, `days`, `price`, `status`) VALUES (?, ?, ?, ?, ?, ?, 'active')");
    $stmt->bind_param("iisiii", $category_id, $server_id, $plan_name, $volume, $days, $price);
    
    if($stmt->execute()){
        $plan_id = $connection->insert_id;
        setUser('none', 'step');
        
        $volume_text = $volume > 0 ? $volume . ' گیگ' : 'نامحدود';
        $price_text = number_format($price);
        
        sendMessage("✅ تعرفه با موفقیت اضافه شد!\n\n🆔 شناسه: #{$plan_id}\n🏷️ نام: {$plan_name}\n🔋 حجم: {$volume_text}\n⏰ مدت: {$days} روز\n💰 قیمت: {$price_text} تومان", getAdminKeys(), 'HTML');
    } else {
        sendMessage("❌ خطا: " . $stmt->error, getAdminKeys());
    }
    $stmt->close();
    exit;
}

// ==================== نمایش دکمه‌های مدیریت در منوی ادمین ====================

// این تابع را در bot.php صدا بزنید تا دکمه‌های مدیریت نمایش داده شود
function getServerManagementButtons(){
    return [
        [['text' => '🖥️ مدیریت سرورها', 'callback_data' => 'manageServers']],
        [['text' => '📦 مدیریت دسته‌بندی‌ها', 'callback_data' => 'manageCategories']],
        [['text' => '🎁 مدیریت تعرفه‌ها', 'callback_data' => 'managePlans']],
    ];
}
?>
