<?php
/**
 * فایل Cron برای ارسال خودکار پیام‌های همگانی
 * این فایل را می‌توانید به صورت دستی یا از طریق cron job اجرا کنید
 * 
 * استفاده:
 * php send_broadcast.php
 * یا از طریق URL:
 * https://lotfisch.ir/send_broadcast.php
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once 'baseInfo.php';
include_once 'config.php';

// بررسی امنیت - فقط از IP سرور یا با کلید مخصوص
$secretKey = "YOUR_SECRET_KEY_HERE"; // این را تغییر دهید
if(isset($_GET['key']) && $_GET['key'] != $secretKey && php_sapi_name() != 'cli'){
    die('Unauthorized access');
}

echo "<pre>";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "🚀 سیستم ارسال پیام همگانی خودکار\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";

// خواندن اطلاعات پیام
if(!file_exists("settings/messagewizwiz.json")){
    echo "❌ فایل تنظیمات یافت نشد!\n";
    exit;
}

$sendInfo = json_decode(file_get_contents("settings/messagewizwiz.json"), true);

// بررسی وضعیت
if(!isset($sendInfo['offset']) || !isset($sendInfo['text'])){
    echo "❌ اطلاعات پیام ناقص است!\n";
    exit;
}

if($sendInfo['offset'] == -1){
    echo "ℹ️  هیچ پیامی برای ارسال وجود ندارد\n";
    exit;
}

$messageData = json_decode($sendInfo['text'], true);
$type = $messageData['type'];
$value = $messageData['value'];
$currentOffset = $sendInfo['offset'];

echo "📊 نوع پیام: $type\n";
echo "📍 آفست فعلی: $currentOffset\n\n";

// دریافت کاربران
$batchSize = 100; // تعداد کاربران در هر دسته
$stmt = $connection->prepare("SELECT `userid` FROM `users` LIMIT ?, ?");
$stmt->bind_param("ii", $currentOffset, $batchSize);
$stmt->execute();
$users = $stmt->get_result();
$stmt->close();

if($users->num_rows == 0){
    echo "✅ ارسال به پایان رسید!\n\n";
    
    // ریست کردن offset
    $sendInfo['offset'] = -1;
    file_put_contents("settings/messagewizwiz.json", json_encode($sendInfo));
    
    // ارسال گزارش نهایی به ادمین
    $stmt = $connection->prepare("SELECT COUNT(*) as total FROM `users`");
    $stmt->execute();
    $totalUsers = $stmt->get_result()->fetch_assoc()['total'];
    $stmt->close();
    
    $reportMsg = "✅ <b>ارسال همگانی با موفقیت به پایان رسید!</b>\n\n";
    $reportMsg .= "👥 کل کاربران: <b>" . number_format($totalUsers) . "</b>\n";
    $reportMsg .= "📅 تاریخ: " . jdate('Y/m/d H:i');
    
    sendMessage($reportMsg, null, "HTML", $admin);
    
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    exit;
}

echo "🔄 شروع ارسال دسته $currentOffset تا " . ($currentOffset + $batchSize) . "\n\n";

$successCount = 0;
$failedCount = 0;
$startTime = microtime(true);

while($user = $users->fetch_assoc()){
    $userId = $user['userid'];
    
    try {
        if($type == 'text'){
            $result = sendMessage($value, null, "HTML", $userId);
        }
        elseif($type == 'photo'){
            $result = sendPhoto($value['fileid'], $value['caption'], null, "HTML", $userId);
        }
        elseif($type == 'video'){
            $result = bot('sendVideo', [
                'chat_id' => $userId,
                'video' => $value['fileid'],
                'caption' => $value['caption'],
                'parse_mode' => 'HTML'
            ]);
        }
        elseif($type == 'document'){
            $result = bot('sendDocument', [
                'chat_id' => $userId,
                'document' => $value['fileid'],
                'caption' => $value['caption'],
                'parse_mode' => 'HTML'
            ]);
        }
        
        if($result && $result->ok){
            $successCount++;
            echo "✅ ارسال به $userId موفق\n";
        } else {
            $failedCount++;
            echo "❌ ارسال به $userId ناموفق\n";
        }
    } catch(Exception $e) {
        $failedCount++;
        echo "❌ خطا در ارسال به $userId: " . $e->getMessage() . "\n";
    }
    
    // تأخیر برای جلوگیری از محدودیت API
    usleep(50000); // 50 میلی‌ثانیه
}

$endTime = microtime(true);
$duration = round($endTime - $startTime, 2);

echo "\n━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "📊 گزارش دسته:\n";
echo "✅ موفق: $successCount\n";
echo "❌ ناموفق: $failedCount\n";
echo "⏱️ زمان: {$duration}s\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";

// بروزرسانی offset
$newOffset = $currentOffset + $batchSize;
$sendInfo['offset'] = $newOffset;
file_put_contents("settings/messagewizwiz.json", json_encode($sendInfo));

echo "💾 Offset جدید: $newOffset ذخیره شد\n";
echo "ℹ️  برای ادامه، دوباره این فایل را اجرا کنید\n\n";

// ارسال گزارش میانی به ادمین (هر 500 کاربر)
if($currentOffset > 0 && $currentOffset % 500 == 0){
    $progressMsg = "📊 <b>گزارش پیشرفت ارسال همگانی</b>\n\n";
    $progressMsg .= "✅ ارسال شده تا الان: <b>$currentOffset</b>\n";
    $progressMsg .= "🔄 آخرین دسته: موفق $successCount، ناموفق $failedCount\n";
    $progressMsg .= "⏱️ زمان دسته: {$duration}s";
    
    sendMessage($progressMsg, null, "HTML", $admin);
}

echo "✅ اتمام عملیات\n";
echo "</pre>";
?>
