<?php
/**
 * حذف جداول قبلی و نصب مجدد
 * این فایل را فقط یک بار اجرا کنید
 */

require_once 'config.php';

echo "<h1>🗑️ حذف و نصب مجدد جداول</h1>";
echo "<pre>";

// حذف جداول قدیمی (اگر وجود دارند)
echo "\n🗑️ حذف جداول قدیمی...\n\n";

$tables_to_drop = [
    'temp_service_purchases',
    'service_orders',
    'service_plans',
    'plan_categories',
    'servers'
];

foreach($tables_to_drop as $table){
    echo "❌ حذف جدول {$table}...\n";
    $sql = "DROP TABLE IF EXISTS `{$table}`";
    if($connection->query($sql)){
        echo "✅ جدول {$table} حذف شد\n";
    } else {
        echo "⚠️ خطا: " . $connection->error . "\n";
    }
}

echo "\n━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "📊 ایجاد جداول جدید...\n\n";

// جدول سرورها
echo "📡 ایجاد جدول servers...\n";
$sql = "CREATE TABLE `servers` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(255) NOT NULL COMMENT 'نام سرور',
    `server_ip` VARCHAR(255) NOT NULL COMMENT 'آی پی سرور',
    `panel_port` INT NOT NULL DEFAULT 2083 COMMENT 'پورت پنل',
    `panel_path` VARCHAR(255) NOT NULL DEFAULT '/' COMMENT 'مسیر پنل',
    `panel_username` VARCHAR(255) NOT NULL COMMENT 'نام کاربری پنل',
    `panel_password` VARCHAR(255) NOT NULL COMMENT 'رمز عبور پنل',
    `protocol` ENUM('http', 'https') NOT NULL DEFAULT 'https' COMMENT 'پروتکل',
    `inbound_id` INT DEFAULT NULL COMMENT 'شناسه Inbound',
    `location` VARCHAR(100) DEFAULT NULL COMMENT 'لوکیشن سرور',
    `status` ENUM('active', 'inactive') NOT NULL DEFAULT 'active',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

if($connection->query($sql)){
    echo "✅ جدول servers ایجاد شد\n";
} else {
    die("❌ خطا: " . $connection->error . "\n");
}

// جدول دسته‌بندی‌ها
echo "\n📦 ایجاد جدول plan_categories...\n";
$sql = "CREATE TABLE `plan_categories` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(255) NOT NULL COMMENT 'نام دسته',
    `emoji` VARCHAR(50) DEFAULT NULL COMMENT 'ایموجی',
    `sort_order` INT NOT NULL DEFAULT 0 COMMENT 'ترتیب نمایش',
    `status` ENUM('active', 'inactive') NOT NULL DEFAULT 'active',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_status` (`status`),
    INDEX `idx_sort` (`sort_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

if($connection->query($sql)){
    echo "✅ جدول plan_categories ایجاد شد\n";
} else {
    die("❌ خطا: " . $connection->error . "\n");
}

// جدول تعرفه‌ها (بدون Foreign Key)
echo "\n🎁 ایجاد جدول service_plans...\n";
$sql = "CREATE TABLE `service_plans` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `category_id` INT NOT NULL COMMENT 'شناسه دسته',
    `server_id` INT NOT NULL COMMENT 'شناسه سرور',
    `name` VARCHAR(255) NOT NULL COMMENT 'نام تعرفه',
    `volume_gb` INT NOT NULL DEFAULT 0 COMMENT 'حجم به گیگ (0=نامحدود)',
    `days` INT NOT NULL COMMENT 'تعداد روز',
    `price` INT NOT NULL COMMENT 'قیمت به تومان',
    `user_limit` INT NOT NULL DEFAULT 1 COMMENT 'تعداد کاربر مجاز',
    `description` TEXT DEFAULT NULL COMMENT 'توضیحات',
    `status` ENUM('active', 'inactive') NOT NULL DEFAULT 'active',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_category` (`category_id`),
    INDEX `idx_server` (`server_id`),
    INDEX `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

if($connection->query($sql)){
    echo "✅ جدول service_plans ایجاد شد\n";
} else {
    die("❌ خطا: " . $connection->error . "\n");
}

// جدول سفارشات (بدون Foreign Key)
echo "\n📝 ایجاد جدول service_orders...\n";
$sql = "CREATE TABLE `service_orders` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `user_id` BIGINT NOT NULL COMMENT 'شناسه کاربر',
    `plan_id` INT NOT NULL COMMENT 'شناسه تعرفه',
    `server_id` INT NOT NULL COMMENT 'شناسه سرور',
    `hash_id` VARCHAR(255) NOT NULL COMMENT 'شناسه یکتا سفارش',
    `email` VARCHAR(255) DEFAULT NULL COMMENT 'ایمیل اکانت در پنل',
    `uuid` VARCHAR(255) DEFAULT NULL COMMENT 'UUID اکانت',
    `inbound_id` INT DEFAULT NULL COMMENT 'شناسه Inbound',
    `config_link` TEXT DEFAULT NULL COMMENT 'لینک کانفیگ',
    `volume_gb` INT NOT NULL COMMENT 'حجم',
    `days` INT NOT NULL COMMENT 'مدت',
    `price` INT NOT NULL COMMENT 'قیمت پرداختی',
    `expire_date` DATETIME DEFAULT NULL COMMENT 'تاریخ انقضا',
    `status` ENUM('pending', 'active', 'expired', 'deleted') NOT NULL DEFAULT 'pending',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_user` (`user_id`),
    INDEX `idx_hash` (`hash_id`),
    INDEX `idx_status` (`status`),
    INDEX `idx_expire` (`expire_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

if($connection->query($sql)){
    echo "✅ جدول service_orders ایجاد شد\n";
} else {
    die("❌ خطا: " . $connection->error . "\n");
}

// جدول خریدهای موقت
echo "\n⏳ ایجاد جدول temp_service_purchases...\n";
$sql = "CREATE TABLE `temp_service_purchases` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `hash_id` VARCHAR(255) NOT NULL UNIQUE COMMENT 'شناسه پرداخت',
    `user_id` INT NOT NULL COMMENT 'شناسه کاربر',
    `plan_id` INT NOT NULL COMMENT 'شناسه تعرفه',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_hash` (`hash_id`),
    INDEX `idx_user` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

if($connection->query($sql)){
    echo "✅ جدول temp_service_purchases ایجاد شد\n";
} else {
    die("❌ خطا: " . $connection->error . "\n");
}

echo "\n━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "📊 وارد کردن داده‌های اولیه...\n\n";

// وارد کردن سرور
echo "🖥️ افزودن سرور آلمان...\n";
$stmt = $connection->prepare("INSERT INTO `servers` (`name`, `server_ip`, `panel_port`, `panel_path`, `panel_username`, `panel_password`, `protocol`, `location`, `status`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'active')");
$name = "سرور آلمان VIP 🇩🇪";
$ip = "82.115.26.209";
$port = 2083;
$path = "/aHfvIoyNWcxlOfBfje";
$username = "parisa";
$password = "@230902Parisa";
$protocol = "https";
$location = "آلمان 🇩🇪";
$stmt->bind_param("ssisssss", $name, $ip, $port, $path, $username, $password, $protocol, $location);
if($stmt->execute()){
    $server_id = $connection->insert_id;
    echo "✅ سرور آلمان اضافه شد (ID: {$server_id})\n";
} else {
    die("❌ خطا: " . $stmt->error . "\n");
}
$stmt->close();

// دسته‌بندی‌ها
echo "\n📦 افزودن دسته‌بندی‌ها...\n";
$categories = [
    ['پلن‌های یک ماهه 📅', '📅', 1],
    ['پلن‌های سه ماهه 📆', '📆', 2],
    ['پلن‌های شش ماهه 📊', '📊', 3]
];

$category_ids = [];
foreach($categories as $cat){
    $stmt = $connection->prepare("INSERT INTO `plan_categories` (`name`, `emoji`, `sort_order`) VALUES (?, ?, ?)");
    $stmt->bind_param("ssi", $cat[0], $cat[1], $cat[2]);
    if($stmt->execute()){
        $category_ids[] = $connection->insert_id;
        echo "✅ دسته '{$cat[0]}' اضافه شد\n";
    }
    $stmt->close();
}

// تعرفه‌ها
echo "\n🎁 افزودن تعرفه‌ها...\n";
$plans = [
    // یک ماهه
    [$category_ids[0], $server_id, '20 گیگ یک ماهه 💎', 20, 30, 40000],
    [$category_ids[0], $server_id, '35 گیگ یک ماهه 💎', 35, 30, 55000],
    [$category_ids[0], $server_id, '50 گیگ یک ماهه 💎', 50, 30, 70000],
    [$category_ids[0], $server_id, '90 گیگ یک ماهه 🔥', 90, 30, 100000],
    [$category_ids[0], $server_id, 'نامحدود یک ماهه ⭐', 0, 30, 150000],
    // سه ماهه
    [$category_ids[1], $server_id, '50 گیگ سه ماهه 💎', 50, 90, 180000],
    [$category_ids[1], $server_id, '100 گیگ سه ماهه 🔥', 100, 90, 270000],
    [$category_ids[1], $server_id, 'نامحدود سه ماهه ⭐', 0, 90, 400000]
];

$count = 0;
foreach($plans as $plan){
    $stmt = $connection->prepare("INSERT INTO `service_plans` (`category_id`, `server_id`, `name`, `volume_gb`, `days`, `price`) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("iisiii", $plan[0], $plan[1], $plan[2], $plan[3], $plan[4], $plan[5]);
    if($stmt->execute()){
        $count++;
    }
    $stmt->close();
}
echo "✅ {$count} تعرفه اضافه شد\n";

echo "\n━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "🎉 نصب با موفقیت کامل شد!\n\n";
echo "📊 جداول ایجاد شده:\n";
echo "   ✅ servers\n";
echo "   ✅ plan_categories\n";
echo "   ✅ service_plans\n";
echo "   ✅ service_orders\n";
echo "   ✅ temp_service_purchases\n\n";
echo "📦 داده‌های اولیه:\n";
echo "   ✅ 1 سرور (آلمان)\n";
echo "   ✅ 3 دسته‌بندی\n";
echo "   ✅ {$count} تعرفه\n\n";
echo "🚀 حالا می‌توانید ربات را تست کنید!\n";
echo "</pre>";
?>
