<?php
// تست سریع - این فایل رو از مرورگر باز کنید
include_once 'config.php';
?>
<!DOCTYPE html>
<html dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تست سریع خرید</title>
    <style>
        body { font-family: Tahoma; padding: 20px; }
        .success { color: green; }
        .error { color: red; }
        .info { color: blue; }
        button { padding: 10px 20px; margin: 5px; }
    </style>
</head>
<body>
    <h1>🚀 تست سریع جریان خرید</h1>
    
    <h2>مرحله 1: بررسی داده‌ها</h2>
    <?php
    // چک دسته‌بندی‌ها
    $cats = $connection->query("SELECT COUNT(*) as total FROM plan_categories WHERE status='active'")->fetch_assoc()['total'];
    echo $cats > 0 ? "<p class='success'>✅ دسته‌بندی: $cats عدد</p>" : "<p class='error'>❌ دسته‌بندی ندارید!</p>";
    
    // چک سرورها
    $servers = $connection->query("SELECT COUNT(*) as total FROM servers WHERE status='active'")->fetch_assoc()['total'];
    echo $servers > 0 ? "<p class='success'>✅ سرور: $servers عدد</p>" : "<p class='error'>❌ سرور ندارید!</p>";
    
    // چک تعرفه‌ها
    $plans = $connection->query("SELECT COUNT(*) as total FROM service_plans WHERE status='active'")->fetch_assoc()['total'];
    echo $plans > 0 ? "<p class='success'>✅ تعرفه: $plans عدد</p>" : "<p class='error'>❌ تعرفه ندارید!</p>";
    ?>
    
    <hr>
    
    <h2>مرحله 2: لیست تعرفه‌های موجود</h2>
    <?php
    $result = $connection->query("
        SELECT sp.id, sp.name, sp.volume_gb, sp.days, sp.price, 
               pc.name as category_name, s.name as server_name
        FROM service_plans sp
        JOIN plan_categories pc ON sp.category_id = pc.id
        JOIN servers s ON sp.server_id = s.id
        WHERE sp.status = 'active'
        LIMIT 10
    ");
    
    if($result->num_rows > 0){
        echo "<table border='1' cellpadding='10' style='border-collapse:collapse; width:100%;'>";
        echo "<tr><th>ID</th><th>نام</th><th>دسته</th><th>حجم</th><th>مدت</th><th>قیمت</th><th>تست</th></tr>";
        while($plan = $result->fetch_assoc()){
            $vol = $plan['volume_gb'] > 0 ? $plan['volume_gb'] . ' GB' : 'نامحدود';
            $price = number_format($plan['price']);
            echo "<tr>";
            echo "<td>{$plan['id']}</td>";
            echo "<td>{$plan['name']}</td>";
            echo "<td>{$plan['category_name']}</td>";
            echo "<td>$vol</td>";
            echo "<td>{$plan['days']} روز</td>";
            echo "<td>$price تومان</td>";
            echo "<td><button onclick='testPlan({$plan['id']})'>تست</button></td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p class='error'>❌ هیچ تعرفه‌ای یافت نشد!</p>";
        echo "<p><a href='add_sample_data.php'>➕ اضافه کردن داده‌های نمونه</a></p>";
    }
    ?>
    
    <hr>
    
    <h2>مرحله 3: تست کلیک</h2>
    <p>روی دکمه "تست" کنار هر پلن کلیک کنید:</p>
    <div id="result"></div>
    
    <script>
    function testPlan(planId) {
        document.getElementById('result').innerHTML = '<p class="info">⏳ در حال بررسی...</p>';
        
        fetch('test_plan_click.php?plan_id=' + planId)
            .then(response => response.text())
            .then(data => {
                document.getElementById('result').innerHTML = data;
            })
            .catch(error => {
                document.getElementById('result').innerHTML = '<p class="error">❌ خطا: ' + error + '</p>';
            });
    }
    </script>
    
    <hr>
    
    <h2>مرحله 4: تست در ربات</h2>
    <ol>
        <li>به ربات برید</li>
        <li>/start بزنید</li>
        <li>"خرید سرویس APN" را بزنید</li>
        <li>یک دسته انتخاب کنید</li>
        <li>یک پلن انتخاب کنید</li>
        <li>اگه صفحه پرداخت اومد ✅ حل شده!</li>
        <li>اگه نیومد، <a href="debug_buy_plan.php">این لینک</a> رو باز کنید</li>
    </ol>
    
</body>
</html>
