<?php
/**
 * اسکریپت نصب جداول برای سیستم اکانت VIP اتوماتیک
 * این فایل را یک بار اجرا کنید تا جداول مورد نیاز ساخته شوند
 */

require_once 'config.php';

echo "🚀 شروع نصب جداول...\n\n";

// ایجاد جدول vip_accounts
$sql_vip_accounts = "
CREATE TABLE IF NOT EXISTS `vip_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL COMMENT 'شناسه کاربر تلگرام',
  `hash_id` varchar(100) NOT NULL COMMENT 'شناسه تراکنش از جدول pays',
  `plan_id` varchar(50) NOT NULL COMMENT 'شناسه پلن (مثل vip1, vip2)',
  `email` varchar(255) NOT NULL COMMENT 'نام اکانت در پنل',
  `uuid` varchar(100) NOT NULL COMMENT 'UUID اکانت',
  `inbound_id` int(11) NOT NULL COMMENT 'شناسه Inbound در پنل',
  `volume_gb` int(11) NOT NULL DEFAULT 0 COMMENT 'حجم به گیگابایت (0=نامحدود)',
  `days` int(11) NOT NULL COMMENT 'تعداد روزهای اعتبار',
  `vless_link` text DEFAULT NULL COMMENT 'لینک VLESS',
  `expire_date` int(11) NOT NULL COMMENT 'تاریخ انقضا (timestamp)',
  `created_at` int(11) NOT NULL COMMENT 'تاریخ ساخت (timestamp)',
  `status` enum('active','expired','deleted','suspended') DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `hash_id` (`hash_id`),
  KEY `email` (`email`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='اکانت‌های VIP ساخته شده';
";

if ($connection->query($sql_vip_accounts) === TRUE) {
    echo "✅ جدول vip_accounts با موفقیت ایجاد شد.\n";
} else {
    echo "❌ خطا در ایجاد جدول vip_accounts: " . $connection->error . "\n";
}

// ایجاد جدول vip_account_logs
$sql_vip_logs = "
CREATE TABLE IF NOT EXISTS `vip_account_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL COMMENT 'شناسه اکانت از جدول vip_accounts',
  `action` varchar(50) NOT NULL COMMENT 'نوع عملیات: created, renewed, deleted, suspended',
  `description` text DEFAULT NULL COMMENT 'توضیحات',
  `created_at` int(11) NOT NULL COMMENT 'زمان عملیات',
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `action` (`action`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='لاگ عملیات روی اکانت‌ها';
";

if ($connection->query($sql_vip_logs) === TRUE) {
    echo "✅ جدول vip_account_logs با موفقیت ایجاد شد.\n";
} else {
    echo "❌ خطا در ایجاد جدول vip_account_logs: " . $connection->error . "\n";
}

// ایجاد جدول vip_plans_status برای فعال/غیرفعال کردن پلن‌ها
$sql_vip_plans_status = "
CREATE TABLE IF NOT EXISTS `vip_plans_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `plan_key` varchar(50) NOT NULL COMMENT 'شناسه پلن (vip1, vip2, ...)',
  `enabled` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'فعال/غیرفعال',
  `updated_at` int(11) NOT NULL COMMENT 'آخرین به‌روزرسانی',
  PRIMARY KEY (`id`),
  UNIQUE KEY `plan_key` (`plan_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='وضعیت فعال/غیرفعال پلن‌های VIP';
";

if ($connection->query($sql_vip_plans_status) === TRUE) {
    echo "✅ جدول vip_plans_status با موفقیت ایجاد شد.\n";
} else {
    echo "❌ خطا در ایجاد جدول vip_plans_status: " . $connection->error . "\n";
}

echo "\n━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
echo "✅ نصب کامل شد!\n\n";
echo "📝 مراحل بعدی:\n";
echo "1️⃣ اطلاعات پنل X-UI را در فایل auto_account_creator.php تنظیم کنید\n";
echo "2️⃣ یک بار تست کنید که اتصال به پنل برقرار می‌شود\n";
echo "3️⃣ از طریق ربات یک پلن VIP خریداری کنید\n";
echo "4️⃣ روی دکمه 'تایید و ارسال اتوماتیک' کلیک کنید\n\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";

$connection->close();
