<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>🔍 پیدا کردن خطای Syntax در bot.php</h1>";
echo "<hr>";

// تلاش برای parse کردن فایل
$file = 'bot.php';
$code = file_get_contents($file);

// بررسی با token_get_all
echo "<h2>بررسی توکن‌ها...</h2>";
try {
    $tokens = @token_get_all($code);
    echo "<p style='color:green;'>✅ توکن‌ها قابل خواندن هستند</p>";
} catch (ParseError $e) {
    echo "<p style='color:red;'>❌ خطای Parse:</p>";
    echo "<pre>" . $e->getMessage() . "</pre>";
    echo "<p>خط: " . $e->getLine() . "</p>";
    exit;
}

// تلاش برای اجرا
echo "<h2>تلاش برای اجرا...</h2>";
ob_start();
try {
    include 'bot.php';
    ob_end_clean();
    echo "<p style='color:green;'>✅ فایل قابل اجراست!</p>";
    echo "<p>پس مشکل از Runtime است، نه Syntax</p>";
} catch (ParseError $e) {
    ob_end_clean();
    echo "<p style='color:red;'>❌ خطای Parse در زمان اجرا:</p>";
    echo "<pre>";
    echo "پیام: " . $e->getMessage() . "\n";
    echo "فایل: " . $e->getFile() . "\n";
    echo "خط: " . $e->getLine() . "\n";
    echo "</pre>";
} catch (Throwable $e) {
    ob_end_clean();
    echo "<p style='color:orange;'>⚠️ خطای Runtime (نه Syntax):</p>";
    echo "<pre>";
    echo "پیام: " . $e->getMessage() . "\n";
    echo "فایل: " . $e->getFile() . "\n";
    echo "خط: " . $e->getLine() . "\n";
    echo "</pre>";
    echo "<p>این خطا Syntax نیست، مشکل از اجرای کد است</p>";
}

echo "<hr>";
echo "<h2>✅ نتیجه</h2>";
echo "<p>اگر خطای Syntax وجود داشت، بالا نمایش داده شد</p>";
?>
