<?php
// تست مستقیم ربات با شبیه‌سازی /start
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<pre>";
echo "🧪 تست مستقیم ربات\n";
echo "====================\n\n";

// شبیه‌سازی ورودی از تلگرام
$fakeUpdate = [
    'update_id' => 123456789,
    'message' => [
        'message_id' => 1,
        'from' => [
            'id' => 8110165534, // آیدی ادمین
            'is_bot' => false,
            'first_name' => 'Test',
            'username' => 'testuser'
        ],
        'chat' => [
            'id' => 8110165534,
            'first_name' => 'Test',
            'username' => 'testuser',
            'type' => 'private'
        ],
        'date' => time(),
        'text' => '/start'
    ]
];

// ذخیره به عنوان ورودی
file_put_contents('php://input', json_encode($fakeUpdate));

echo "1️⃣ شبیه‌سازی ورودی:\n";
echo json_encode($fakeUpdate, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n\n";

echo "2️⃣ بررسی فایل‌های ضروری:\n";
$files = ['config.php', 'baseInfo.php', 'settings/values.php'];
foreach($files as $file) {
    if(file_exists($file)) {
        echo "✅ $file\n";
    } else {
        echo "❌ $file - وجود ندارد\n";
    }
}

echo "\n3️⃣ تست include کردن config:\n";
try {
    ob_start();
    include_once 'baseInfo.php';
    echo "✅ baseInfo.php لود شد\n";
    
    include_once 'settings/values.php';
    echo "✅ values.php لود شد\n";
    
    // اتصال به دیتابیس
    $connection = new mysqli('localhost', $dbUserName, $dbPassword, $dbName);
    if($connection->connect_error) {
        echo "❌ خطا در اتصال به دیتابیس\n";
    } else {
        echo "✅ اتصال به دیتابیس موفق\n";
        $connection->set_charset("utf8mb4");
    }
    
    ob_end_clean();
} catch(Exception $e) {
    ob_end_clean();
    echo "❌ خطا: " . $e->getMessage() . "\n";
}

echo "\n4️⃣ تست تابع bot:\n";
function bot($method, $datas = []){
    global $botToken;
    $url = "https://api.telegram.org/bot" . $botToken . "/" . $method;
    $ch = curl_init(); 
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($datas));
    $res = curl_exec($ch);
    if (curl_error($ch)) {
        return ['ok' => false, 'error' => curl_error($ch)];
    } else {
        return json_decode($res, true);
    }
}

$test = bot('getMe');
if($test['ok']) {
    echo "✅ تابع bot کار می‌کند\n";
    echo "   نام ربات: " . $test['result']['first_name'] . "\n";
} else {
    echo "❌ خطا در تابع bot\n";
}

echo "\n5️⃣ بررسی $mainValues:\n";
if(isset($mainValues['start_message'])) {
    echo "✅ mainValues['start_message'] وجود دارد\n";
    echo "   محتوا: " . substr($mainValues['start_message'], 0, 50) . "...\n";
} else {
    echo "❌ mainValues['start_message'] وجود ندارد\n";
}

echo "\n6️⃣ ارسال پیام تست:\n";
if(isset($botToken) && isset($admin)) {
    $result = bot('sendMessage', [
        'chat_id' => $admin,
        'text' => "🧪 تست موفقیت‌آمیز!\n\nفایل‌ها به درستی لود شدند."
    ]);
    
    if($result['ok']) {
        echo "✅ پیام تست ارسال شد\n";
    } else {
        echo "❌ خطا در ارسال: " . ($result['description'] ?? 'نامشخص') . "\n";
    }
} else {
    echo "❌ متغیرهای botToken یا admin تعریف نشده‌اند\n";
}

echo "\n====================\n";
echo "✅ تست کامل شد\n";
echo "</pre>";
?>
