<?php
/**
 * دیباگ لحظه‌ای - مشاهده آخرین اکشن کاربر
 */

include_once 'config.php';

echo "<!DOCTYPE html><html dir='rtl'><head><meta charset='UTF-8'><title>دیباگ</title>";
echo "<style>body{font-family:Tahoma;padding:20px;} .error{color:red;} .success{color:green;} .info{color:blue;} pre{background:#f5f5f5;padding:10px;direction:ltr;text-align:left;}</style>";
echo "</head><body>";

echo "<h1>🔍 دیباگ سیستم فیش</h1>";
echo "<hr>";

// دریافت آیدی کاربر برای تست
$test_user_id = $_GET['user_id'] ?? $admin;

echo "<form method='get'>";
echo "<label>آیدی کاربر برای تست:</label> ";
echo "<input type='number' name='user_id' value='{$test_user_id}' style='padding:5px;'> ";
echo "<button type='submit'>بررسی</button>";
echo "</form>";
echo "<hr>";

// دریافت اطلاعات کاربر
$stmt = $connection->prepare("SELECT * FROM `users` WHERE `userid`=?");
$stmt->bind_param("i", $test_user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();

if(!$user){
    echo "<p class='error'>❌ کاربر با این آیدی یافت نشد!</p>";
    exit;
}

echo "<h2>👤 اطلاعات کاربر</h2>";
echo "<table border='1' cellpadding='8' style='border-collapse:collapse;'>";
echo "<tr><td><strong>آیدی:</strong></td><td>{$user['userid']}</td></tr>";
echo "<tr><td><strong>نام:</strong></td><td>{$user['name']}</td></tr>";
echo "<tr><td><strong>یوزرنیم:</strong></td><td>{$user['username']}</td></tr>";
echo "<tr><td><strong>Step فعلی:</strong></td><td><code>" . ($user['step'] ?? 'none') . "</code></td></tr>";
echo "</table>";

echo "<hr>";

// چک کردن step
if(isset($user['step']) && preg_match('/^uploadReceiptForPlan_(\d+)$/', $user['step'], $match)){
    $plan_id = $match[1];
    echo "<p class='success'>✅ کاربر در حالت دریافت فیش برای پلن شماره: <strong>{$plan_id}</strong></p>";
    
    // دریافت اطلاعات پلن
    $stmt = $connection->prepare("SELECT * FROM `service_plans` WHERE `id` = ?");
    $stmt->bind_param("i", $plan_id);
    $stmt->execute();
    $plan = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    if($plan){
        echo "<h3>📦 اطلاعات پلن:</h3>";
        echo "<ul>";
        echo "<li>نام: {$plan['name']}</li>";
        echo "<li>قیمت: " . number_format($plan['price']) . " تومان</li>";
        echo "<li>وضعیت: {$plan['status']}</li>";
        echo "</ul>";
    }
    
    echo "<p class='info'>📝 الان باید عکس فیش رو بفرستید تا دریافت بشه.</p>";
} else {
    echo "<p class='error'>❌ کاربر در حالت دریافت فیش نیست!</p>";
    echo "<p>Step فعلی: <code>" . ($user['step'] ?? 'none') . "</code></p>";
}

echo "<hr>";

// آخرین فیش‌های ثبت شده
echo "<h2>📋 آخرین فیش‌های ثبت شده (کل سیستم)</h2>";
$result = $connection->query("SELECT p.*, u.name 
                               FROM pays p 
                               LEFT JOIN users u ON p.user_id = u.userid 
                               WHERE p.type='SERVICE_PLAN' 
                               ORDER BY p.id DESC 
                               LIMIT 10");

if($result && $result->num_rows > 0){
    echo "<table border='1' cellpadding='8' style='border-collapse:collapse; width:100%;'>";
    echo "<tr><th>ID</th><th>کاربر</th><th>مبلغ</th><th>وضعیت</th><th>Hash</th><th>عکس</th></tr>";
    while($pay = $result->fetch_assoc()){
        $has_photo = !empty($pay['photo']) ? '✅ دارد' : '❌ ندارد';
        echo "<tr>";
        echo "<td>{$pay['id']}</td>";
        echo "<td>{$pay['name']} ({$pay['user_id']})</td>";
        echo "<td>" . number_format($pay['price']) . "</td>";
        echo "<td>{$pay['state']}</td>";
        echo "<td><small>{$pay['hash_id']}</small></td>";
        echo "<td>{$has_photo}</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>هیچ فیشی ثبت نشده</p>";
}

echo "<hr>";

// لاگ webhook
echo "<h2>📡 بررسی webhook</h2>";
$webhook_info = bot('getWebhookInfo', []);
if($webhook_info->ok){
    $info = $webhook_info->result;
    echo "<table border='1' cellpadding='8' style='border-collapse:collapse;'>";
    echo "<tr><td><strong>URL:</strong></td><td>{$info->url}</td></tr>";
    echo "<tr><td><strong>Pending Updates:</strong></td><td>{$info->pending_update_count}</td></tr>";
    if(isset($info->last_error_message)){
        echo "<tr><td><strong>آخرین خطا:</strong></td><td class='error'>{$info->last_error_message}</td></tr>";
        echo "<tr><td><strong>زمان خطا:</strong></td><td>" . date('Y-m-d H:i:s', $info->last_error_date) . "</td></tr>";
    }
    echo "</table>";
} else {
    echo "<p class='error'>خطا در دریافت اطلاعات webhook</p>";
}

echo "<hr>";

// راهنما
echo "<h2>🔧 راهنمای عیب‌یابی</h2>";
echo "<ol>";
echo "<li><strong>اگه Step درست نیست:</strong> یعنی دکمه «پرداخت فیش بانکی» کار نکرده</li>";
echo "<li><strong>اگه عکس دریافت نمیشه:</strong> ممکنه متغیر \$photo تعریف نشده باشه</li>";
echo "<li><strong>اگه پیام به ادمین نمیره:</strong> بررسی کنید تابع bot() کار میکنه یا نه</li>";
echo "</ol>";

echo "<hr>";

// تست ارسال پیام
echo "<h2>📤 تست ارسال پیام</h2>";
echo "<p>برای تست اینکه آیا ربات می‌تونه پیام بفرسته:</p>";

if(isset($_GET['test_send'])){
    $test_msg = bot('sendMessage', [
        'chat_id' => $test_user_id,
        'text' => '🧪 تست ارسال پیام - ' . date('H:i:s')
    ]);
    
    if($test_msg->ok){
        echo "<p class='success'>✅ پیام با موفقیت ارسال شد!</p>";
    } else {
        echo "<p class='error'>❌ خطا در ارسال: " . ($test_msg->description ?? 'نامشخص') . "</p>";
    }
}

echo "<a href='?user_id={$test_user_id}&test_send=1'><button>تست ارسال پیام</button></a>";

echo "<hr>";
echo "<p><a href='debug_live.php?user_id={$test_user_id}'>🔄 Refresh</a></p>";
echo "</body></html>";
?>
