-- جدول کدهای تخفیف
CREATE TABLE IF NOT EXISTS `discounts` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `code` VARCHAR(50) NOT NULL UNIQUE,
  `type` ENUM('percent', 'fixed') NOT NULL DEFAULT 'percent',
  `amount` INT NOT NULL,
  `max_use` INT DEFAULT 0 COMMENT '0 = نامحدود',
  `used_count` INT DEFAULT 0,
  `expire_date` DATETIME DEFAULT NULL,
  `status` ENUM('active', 'inactive') DEFAULT 'active',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `idx_code` (`code`),
  INDEX `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- جدول استفاده از کدهای تخفیف
CREATE TABLE IF NOT EXISTS `discount_usage` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `user_id` BIGINT NOT NULL,
  `discount_id` INT NOT NULL,
  `plan_id` INT NOT NULL,
  `discount_amount` INT NOT NULL,
  `used_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `idx_user_discount` (`user_id`, `discount_id`),
  INDEX `idx_discount` (`discount_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- اضافه کردن ستون discount_id به جدول pays (اگر وجود نداشت)
ALTER TABLE `pays` 
ADD COLUMN IF NOT EXISTS `discount_id` INT DEFAULT NULL;

-- اضافه کردن ستون discount_id به جدول temp_service_purchases (اگر وجود نداشت)
ALTER TABLE `temp_service_purchases` 
ADD COLUMN IF NOT EXISTS `discount_id` INT DEFAULT NULL;

-- مثال: اضافه کردن یک کد تخفیف تستی
INSERT INTO `discounts` (`code`, `type`, `amount`, `max_use`, `expire_date`, `status`) 
VALUES 
('WELCOME20', 'percent', 20, 100, DATE_ADD(NOW(), INTERVAL 30 DAY), 'active'),
('SAVE50K', 'fixed', 50000, 50, DATE_ADD(NOW(), INTERVAL 15 DAY), 'active')
ON DUPLICATE KEY UPDATE 
`max_use` = VALUES(`max_use`),
`expire_date` = VALUES(`expire_date`),
`status` = VALUES(`status`);
