<?php
/**
 * اضافه کردن داده‌های نمونه برای تست
 * این فایل رو فقط یک بار اجرا کنید
 */

include_once 'config.php';

echo "<h1>📦 اضافه کردن داده‌های نمونه</h1>";
echo "<hr>";

// 1. اضافه کردن دسته‌بندی‌ها
echo "<h2>1️⃣ اضافه کردن دسته‌بندی‌ها</h2>";

$categories = [
    ['name' => 'پلن استاندارد', 'emoji' => '📦', 'sort_order' => 1],
    ['name' => 'پلن پریمیوم', 'emoji' => '⭐', 'sort_order' => 2],
    ['name' => 'پلن VIP', 'emoji' => '👑', 'sort_order' => 3]
];

foreach($categories as $cat){
    // چک کنیم وجود داره یا نه
    $stmt = $connection->prepare("SELECT id FROM `plan_categories` WHERE `name` = ?");
    $stmt->bind_param("s", $cat['name']);
    $stmt->execute();
    $exists = $stmt->get_result()->num_rows > 0;
    $stmt->close();
    
    if(!$exists){
        $stmt = $connection->prepare("INSERT INTO `plan_categories` (`name`, `emoji`, `status`, `sort_order`) VALUES (?, ?, 'active', ?)");
        $stmt->bind_param("ssi", $cat['name'], $cat['emoji'], $cat['sort_order']);
        if($stmt->execute()){
            echo "<p style='color:green;'>✅ دسته «{$cat['name']}» اضافه شد</p>";
        } else {
            echo "<p style='color:red;'>❌ خطا در اضافه کردن «{$cat['name']}»</p>";
        }
        $stmt->close();
    } else {
        echo "<p style='color:orange;'>⚠️ دسته «{$cat['name']}» قبلا وجود داشت</p>";
    }
}

echo "<hr>";

// 2. اضافه کردن سرور نمونه
echo "<h2>2️⃣ اضافه کردن سرور نمونه</h2>";

$stmt = $connection->prepare("SELECT id FROM `servers` WHERE `name` = 'سرور آلمان'");
$stmt->execute();
$server_exists = $stmt->get_result()->num_rows > 0;
$stmt->close();

if(!$server_exists){
    $stmt = $connection->prepare("INSERT INTO `servers` 
        (`name`, `location`, `server_ip`, `panel_port`, `panel_path`, `panel_username`, `panel_password`, `protocol`, `inbound_id`, `status`) 
        VALUES ('سرور آلمان', 'Germany 🇩🇪', '82.115.26.209', 2053, '/panel', 'admin', 'admin123', 'vless', 1, 'active')");
    
    if($stmt->execute()){
        $server_id = $connection->insert_id;
        echo "<p style='color:green;'>✅ سرور آلمان اضافه شد (ID: $server_id)</p>";
    } else {
        echo "<p style='color:red;'>❌ خطا در اضافه کردن سرور</p>";
    }
    $stmt->close();
} else {
    echo "<p style='color:orange;'>⚠️ سرور آلمان قبلا وجود داشت</p>";
    $stmt = $connection->prepare("SELECT id FROM `servers` WHERE `name` = 'سرور آلمان' LIMIT 1");
    $stmt->execute();
    $server_id = $stmt->get_result()->fetch_assoc()['id'];
    $stmt->close();
}

echo "<hr>";

// 3. اضافه کردن تعرفه‌ها
echo "<h2>3️⃣ اضافه کردن تعرفه‌های نمونه</h2>";

// دریافت ID دسته‌بندی‌ها
$stmt = $connection->prepare("SELECT id, name FROM `plan_categories` ORDER BY sort_order");
$stmt->execute();
$cats = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

$plans = [
    // پلن‌های استاندارد
    ['name' => '10 گیگ یک ماهه', 'category' => 'پلن استاندارد', 'volume' => 10, 'days' => 30, 'price' => 50000],
    ['name' => '20 گیگ یک ماهه', 'category' => 'پلن استاندارد', 'volume' => 20, 'days' => 30, 'price' => 90000],
    ['name' => '30 گیگ یک ماهه', 'category' => 'پلن استاندارد', 'volume' => 30, 'days' => 30, 'price' => 120000],
    
    // پلن‌های پریمیوم
    ['name' => '50 گیگ یک ماهه', 'category' => 'پلن پریمیوم', 'volume' => 50, 'days' => 30, 'price' => 180000],
    ['name' => '100 گیگ یک ماهه', 'category' => 'پلن پریمیوم', 'volume' => 100, 'days' => 30, 'price' => 300000],
    ['name' => '150 گیگ یک ماهه', 'category' => 'پلن پریمیوم', 'volume' => 150, 'days' => 30, 'price' => 400000],
    
    // پلن‌های VIP
    ['name' => 'نامحدود یک ماهه', 'category' => 'پلن VIP', 'volume' => 0, 'days' => 30, 'price' => 500000],
    ['name' => 'نامحدود سه ماهه', 'category' => 'پلن VIP', 'volume' => 0, 'days' => 90, 'price' => 1200000],
    ['name' => 'نامحدود شش ماهه', 'category' => 'پلن VIP', 'volume' => 0, 'days' => 180, 'price' => 2000000],
];

foreach($plans as $plan){
    // پیدا کردن ID دسته
    $category_id = null;
    foreach($cats as $cat){
        if($cat['name'] == $plan['category']){
            $category_id = $cat['id'];
            break;
        }
    }
    
    if(!$category_id){
        echo "<p style='color:red;'>❌ دسته «{$plan['category']}» یافت نشد</p>";
        continue;
    }
    
    // چک کنیم وجود داره یا نه
    $stmt = $connection->prepare("SELECT id FROM `service_plans` WHERE `name` = ? AND `category_id` = ?");
    $stmt->bind_param("si", $plan['name'], $category_id);
    $stmt->execute();
    $exists = $stmt->get_result()->num_rows > 0;
    $stmt->close();
    
    if(!$exists){
        $stmt = $connection->prepare("INSERT INTO `service_plans` 
            (`category_id`, `server_id`, `name`, `volume_gb`, `days`, `price`, `status`) 
            VALUES (?, ?, ?, ?, ?, ?, 'active')");
        $stmt->bind_param("iisiii", $category_id, $server_id, $plan['name'], $plan['volume'], $plan['days'], $plan['price']);
        
        if($stmt->execute()){
            echo "<p style='color:green;'>✅ پلن «{$plan['name']}» در دسته «{$plan['category']}» اضافه شد</p>";
        } else {
            echo "<p style='color:red;'>❌ خطا در اضافه کردن «{$plan['name']}»: " . $stmt->error . "</p>";
        }
        $stmt->close();
    } else {
        echo "<p style='color:orange;'>⚠️ پلن «{$plan['name']}» قبلا وجود داشت</p>";
    }
}

echo "<hr>";

// خلاصه
echo "<h2>📊 خلاصه</h2>";

$stmt = $connection->prepare("SELECT COUNT(*) as total FROM `plan_categories` WHERE status='active'");
$stmt->execute();
$total_cats = $stmt->get_result()->fetch_assoc()['total'];
$stmt->close();

$stmt = $connection->prepare("SELECT COUNT(*) as total FROM `servers` WHERE status='active'");
$stmt->execute();
$total_servers = $stmt->get_result()->fetch_assoc()['total'];
$stmt->close();

$stmt = $connection->prepare("SELECT COUNT(*) as total FROM `service_plans` WHERE status='active'");
$stmt->execute();
$total_plans = $stmt->get_result()->fetch_assoc()['total'];
$stmt->close();

echo "<ul>";
echo "<li>تعداد دسته‌بندی‌ها: <strong>$total_cats</strong></li>";
echo "<li>تعداد سرورها: <strong>$total_servers</strong></li>";
echo "<li>تعداد تعرفه‌ها: <strong>$total_plans</strong></li>";
echo "</ul>";

if($total_cats > 0 && $total_servers > 0 && $total_plans > 0){
    echo "<p style='color:green; font-size:20px;'>✅ همه چیز آماده است!</p>";
    echo "<p>حالا ربات رو تست کنید:</p>";
    echo "<ol>";
    echo "<li>به ربات برید و /start بزنید</li>";
    echo "<li>روی «خرید سرویس APN» کلیک کنید</li>";
    echo "<li>یک دسته انتخاب کنید</li>";
    echo "<li>یک پلن انتخاب کنید</li>";
    echo "<li>روش پرداخت را انتخاب کنید</li>";
    echo "</ol>";
} else {
    echo "<p style='color:red;'>❌ هنوز ناقص است! دوباره این صفحه را اجرا کنید.</p>";
}

echo "<hr>";
echo "<p><a href='test_buy_flow.php'>🔍 بررسی دوباره سیستم</a></p>";
?>
