# 📡 راهنمای نصب API روی سرور VPS

چون **هاست و VPS جدا هستند**، باید فایل API رو روی سرور VPS نصب کنی.

---

## 🔧 مراحل نصب روی VPS:

### 1️⃣ اتصال به VPS با SSH

```bash
ssh root@82.115.26.209
```

### 2️⃣ ایجاد پوشه API

```bash
mkdir -p /var/www/api
cd /var/www/api
```

### 3️⃣ ایجاد فایل API

فایل `vps_api_create_account.php` که ساختم رو به این مسیر آپلود کن:
```
/var/www/api/create_vip_account.php
```

**یا با nano ایجاد کن:**

```bash
nano /var/www/api/create_vip_account.php
```

محتوای فایل `vps_api_create_account.php` رو کپی کن و paste کن، سپس:
- `Ctrl + O` برای ذخیره
- `Enter` برای تایید
- `Ctrl + X` برای خروج

### 4️⃣ تغییر API Secret Key

فایل رو ویرایش کن:

```bash
nano /var/www/api/create_vip_account.php
```

این خط رو پیدا کن:
```php
define('API_SECRET_KEY', 'YOUR_SECRET_KEY_HERE_CHANGE_THIS');
```

یک کلید امنیتی قوی بساز (مثلا):
```php
define('API_SECRET_KEY', 'apn_vip_2025_secure_key_xyz123');
```

### 5️⃣ تنظیم دسترسی‌ها

```bash
chmod 644 /var/www/api/create_vip_account.php
chown www-data:www-data /var/www/api/create_vip_account.php
```

### 6️⃣ نصب وب سرور (اگر نداری)

#### روش A: استفاده از Nginx (توصیه می‌شود)

```bash
apt update
apt install nginx php-fpm php-curl -y
```

ایجاد config:
```bash
nano /etc/nginx/sites-available/api
```

محتوا:
```nginx
server {
    listen 80;
    server_name 82.115.26.209;
    
    root /var/www;
    index index.php;
    
    location /api/ {
        try_files $uri $uri/ =404;
    }
    
    location ~ \.php$ {
        include snippets/fastcgi-php.conf;
        fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
    }
}
```

فعال کردن:
```bash
ln -s /etc/nginx/sites-available/api /etc/nginx/sites-enabled/
nginx -t
systemctl restart nginx
```

#### روش B: استفاده از Apache

```bash
apt update
apt install apache2 php libapache2-mod-php php-curl -y
a2enmod rewrite
systemctl restart apache2
```

### 7️⃣ تست API

از مرورگر یا curl تست کن:

```bash
curl -X POST http://82.115.26.209/api/create_vip_account.php \
  -H "Content-Type: application/json" \
  -H "X-API-Key: apn_vip_2025_secure_key_xyz123" \
  -d '{"action":"test_connection"}'
```

اگر جواب `{"success":true}` برگشت، کار می‌کنه! ✅

---

## 🔑 تنظیم API Key در هاست

حالا برو تو هاست و فایل `auto_account_creator.php` رو ویرایش کن:

```php
define('VPS_API_URL', 'http://82.115.26.209/api/create_vip_account.php');
define('VPS_API_SECRET', 'apn_vip_2025_secure_key_xyz123'); // همون کلیدی که تو VPS گذاشتی
```

**⚠️ مهم:** `VPS_API_SECRET` باید **دقیقاً** مثل `API_SECRET_KEY` در VPS باشه!

---

## 🧪 تست کامل سیستم

### 1. از هاست:

فایل تست بساز: `test_vps_api.php`

```php
<?php
require_once 'auto_account_creator.php';

echo "<h2>🧪 تست اتصال به VPS API</h2>";

$result = callVPSApi('test_connection');

echo "<pre>";
print_r($result);
echo "</pre>";

if ($result['success']) {
    echo "<h3 style='color: green;'>✅ اتصال موفق!</h3>";
} else {
    echo "<h3 style='color: red;'>❌ خطا: " . ($result['error'] ?? 'Unknown') . "</h3>";
}
?>
```

اجرا کن:
```
https://your-host.com/robotali/test_vps_api.php
```

### 2. تست ساخت اکانت:

```php
<?php
require_once 'auto_account_creator.php';
require_once 'vip_plans_handler.php';

$result = createVIPAccount(123456, 'vip1', 'test_hash_123');

echo "<pre>";
print_r($result);
echo "</pre>";
?>
```

---

## 🔒 امنیت

### 1. محدود کردن IP ها (اختیاری):

در VPS، فایل API رو ویرایش کن و این رو اضافه کن:

```php
// لیست IP های مجاز (IP هاست شما)
$allowed_ips = ['HOST_SERVER_IP'];

if (!in_array($_SERVER['REMOTE_ADDR'], $allowed_ips)) {
    http_response_code(403);
    echo json_encode(['error' => 'IP not allowed']);
    exit;
}
```

### 2. استفاده از HTTPS (توصیه می‌شود):

```bash
apt install certbot python3-certbot-nginx -y
certbot --nginx -d your-domain.com
```

بعد URL رو تغییر بده:
```php
define('VPS_API_URL', 'https://your-domain.com/api/create_vip_account.php');
```

---

## 📊 نتیجه:

```
[هاست cPanel]  →  HTTP Request  →  [VPS API]  →  [X-UI Panel]
  (ربات)                              (localhost)    (ساخت اکانت)
```

این روش:
- ✅ هاست و VPS جدا هستند
- ✅ امن است (API Key)
- ✅ سریع است (local connection to X-UI)
- ✅ قابل توسعه است

---

## 🐛 عیب‌یابی:

### خطا: Connection refused

```bash
# چک کردن Nginx/Apache
systemctl status nginx
# یا
systemctl status apache2

# چک کردن پورت 80
netstat -tlnp | grep :80
```

### خطا: 403 Forbidden

```bash
# چک کردن دسترسی‌ها
ls -la /var/www/api/
chmod 644 /var/www/api/create_vip_account.php
```

### خطا: Invalid API key

- مطمئن شو API_SECRET_KEY در VPS و VPS_API_SECRET در هاست یکسان هستند
- حروف کوچک/بزرگ مهم است!

---

**موفق باشی! 🚀**
