# 🚀 راهنمای نصب و راه‌اندازی سیستم اکانت VIP اتوماتیک

این سیستم به طور خودکار بعد از تایید پرداخت، اکانت VIP را در پنل X-UI شما می‌سازد و به کاربر ارسال می‌کند.

---

## 📋 فایل‌های اضافه شده

1. **xui_api.php** - کلاس API برای اتصال به پنل Sanaei X-UI
2. **auto_account_creator.php** - سیستم ساخت خودکار اکانت
3. **account_manager.php** - مدیریت اکانت‌های کاربران
4. **install_vip_auto_system.php** - اسکریپت نصب جداول
5. **create_vip_accounts_table.sql** - فایل SQL جداول

---

## ⚙️ مراحل نصب

### مرحله 1: نصب جداول دیتابیس

از طریق مرورگر این فایل را اجرا کنید:

```
https://DOMAIN.com/robotali/install_vip_auto_system.php
```

یا از طریق SSH:

```bash
cd /path/to/robotali
php install_vip_auto_system.php
```

این کار جداول زیر را می‌سازد:
- `vip_accounts` - ذخیره اطلاعات اکانت‌های ساخته شده
- `vip_account_logs` - لاگ عملیات روی اکانت‌ها
- `vip_plans_status` - فعال/غیرفعال کردن پلن‌ها

---

### مرحله 2: تنظیم اطلاعات پنل X-UI

فایل `auto_account_creator.php` را باز کنید و اطلاعات زیر را وارد کنید:

```php
// تنظیمات سرور X-UI
define('XUI_PANEL_URL', 'https://apn.lotfischool.ir:2083/aHfvIoyNWcxlOfBfje/panel');
define('XUI_USERNAME', 'parisa');
define('XUI_PASSWORD', '@230902Parisa');
define('XUI_DEBUG', true); // برای دیباگ true بگذارید
```

**✅ این تنظیمات از قبل وارد شده است!**

---

### مرحله 3: تست اتصال به پنل

یک فایل تست با نام `test_xui_connection.php` بسازید:

```php
<?php
require_once 'xui_api.php';

$xui = new XUI_API(
    'https://apn.lotfischool.ir:2083/aHfvIoyNWcxlOfBfje/panel',
    'parisa',
    '@230902Parisa',
    true
);

echo "🔄 در حال تست اتصال به پنل...\n\n";

if ($xui->login()) {
    echo "✅ اتصال به پنل موفق بود!\n\n";
    
    // دریافت لیست Inbound ها
    $inbounds = $xui->getInbounds();
    
    if ($inbounds) {
        echo "📋 لیست Inbound ها:\n";
        foreach ($inbounds as $inbound) {
            echo "- ID: {$inbound['id']} | پروتکل: {$inbound['protocol']} | پورت: {$inbound['port']}\n";
        }
    }
    
    // پیدا کردن VLESS Inbound
    $vless = $xui->findVlessInbound();
    if ($vless) {
        echo "\n✅ VLESS Inbound پیدا شد: ID {$vless['id']}\n";
    } else {
        echo "\n⚠️ VLESS Inbound پیدا نشد!\n";
    }
    
} else {
    echo "❌ خطا در اتصال به پنل!\n";
    echo "لطفا اطلاعات ورود را بررسی کنید.\n";
}
```

این فایل را از مرورگر اجرا کنید:
```
https://DOMAIN.com/robotali/test_xui_connection.php
```

---

## 🎯 نحوه استفاده

### برای کاربران:

1. **خرید پلن VIP:**
   - کاربر از منوی ربات گزینه "خرید سرویس" را انتخاب می‌کند
   - یکی از پلن‌های VIP را انتخاب می‌کند
   - روش پرداخت (کارت به کارت) را انتخاب می‌کند
   - فیش واریز را ارسال می‌کند

2. **تایید ادمین:**
   - ادمین پیام خرید را دریافت می‌کند
   - دو دکمه دارد:
     - ✅ **تایید و ارسال اتوماتیک** - اکانت خودکار ساخته و ارسال می‌شود
     - ✅ **تایید** - فقط تایید می‌شود (بدون ساخت اکانت)
     - ❌ **رد** - درخواست رد می‌شود

3. **دریافت اکانت:**
   - بعد از کلیک روی "تایید و ارسال اتوماتیک":
     - اکانت در پنل X-UI ساخته می‌شود
     - لینک VLESS به کاربر ارسال می‌شود
     - اطلاعات در دیتابیس ذخیره می‌شود

4. **مشاهده اکانت‌ها:**
   - کاربر می‌تواند از منوی ربات "اکانت‌های من" را انتخاب کند
   - لیست همه اکانت‌های VIP خود را ببیند
   - جزئیات و لینک هر اکانت را مشاهده کند
   - وضعیت مصرف را بررسی کند

---

## 🔧 تنظیمات پیشرفته

### فعال/غیرفعال کردن دیباگ

در فایل `auto_account_creator.php`:

```php
define('XUI_DEBUG', false); // برای خاموش کردن لاگ‌ها
```

### مشاهده لاگ‌ها

لاگ‌های عملیات در این فایل‌ها ذخیره می‌شود:
- `xui_api_debug.log` - لاگ API
- `auto_account.log` - لاگ ساخت اکانت

---

## 📊 ویژگی‌ها

✅ **ساخت خودکار اکانت** - بعد از تایید پرداخت
✅ **پشتیبانی از VLESS** - پروتکل امن و سریع
✅ **مدیریت اکانت‌ها** - مشاهده و بررسی مصرف
✅ **لاگ کامل** - ثبت تمام عملیات
✅ **امنیت بالا** - اتصال HTTPS به پنل
✅ **خطاهای واضح** - پیام‌های خطای قابل فهم

---

## ⚠️ نکات مهم

1. **امنیت:**
   - فایل `auto_account_creator.php` حاوی اطلاعات حساس است
   - از `.htaccess` برای محافظت استفاده کنید

2. **Inbound:**
   - پنل شما باید حداقل یک Inbound با پروتکل VLESS داشته باشد
   - اگر ندارید، از پنل یکی بسازید

3. **SSL:**
   - پنل شما باید روی HTTPS باشد
   - در غیر این صورت اتصال ممکن است با خطا مواجه شود

4. **تست:**
   - حتماً قبل از استفاده واقعی، یک بار تست کنید
   - با یک خرید آزمایشی امتحان کنید

---

## 🐛 رفع مشکلات

### خطا: "Failed to login to X-UI panel"

**راه حل:**
- یوزرنیم و پسورد را چک کنید
- آدرس پنل را بررسی کنید (باید شامل `/panel` باشد)
- SSL سرور را بررسی کنید

### خطا: "No VLESS inbound found"

**راه حل:**
- وارد پنل X-UI شوید
- یک Inbound با پروتکل VLESS بسازید
- دوباره تست کنید

### خطا: "Failed to create client"

**راه حل:**
- لاگ `xui_api_debug.log` را بررسی کنید
- مشخصات Inbound را چک کنید
- Session کوکی ممکن است منقضی شده باشد (دوباره login کنید)

---

## 📞 پشتیبانی

در صورت بروز مشکل:
1. فایل‌های لاگ را بررسی کنید
2. Debug mode را فعال کنید
3. اطلاعات خطا را یادداشت کنید

---

## 🎉 تمام!

حالا سیستم شما آماده است! 

**تست اول:**
1. یک پلن VIP خریداری کنید
2. روی "تایید و ارسال اتوماتیک" کلیک کنید
3. اکانت باید خودکار ساخته شود و به کاربر ارسال شود

**موفق باشید! 🚀**
