# 🔄 آپدیت مدیریت فیش‌های واریزی

## 📋 تغییرات اعمال شده

### ✅ 1. حذف سرویس‌های عادی از منوی انتخاب سرویس

**قبل:**
```
✅ انتخاب سرویس:
- 🔥 پلن‌های VIP
- 🛍 سرویس‌های عادی
- 📈 پلن‌های Trading
```

**بعد:**
```
✅ انتخاب سرویس:
- 🔥 پلن‌های VIP
- 📈 پلن‌های Trading

💡 راهنما:
🔥 پلن VIP: اشتراک پرسرعت با ترافیک بالا
📈 پلن Trading: برای معامله‌گری ارزهای دیجیتال
```

**فایل‌های تغییر یافته:**
- `discount_system.php` (3 قسمت)

---

### ✅ 2. اضافه کردن Hint راهنما

در تمام صفحات انتخاب سرویس، راهنمای زیر اضافه شد:

```
💡 راهنما:
🔥 پلن VIP: اشتراک پرسرعت با ترافیک بالا
📈 پلن Trading: برای معامله‌گری ارزهای دیجیتال
```

این راهنما به کاربران کمک می‌کند تا بهتر متوجه شوند هر سرویس برای چیست.

---

### ✅ 3. نمایش فیش واریزی در پنل مدیریت

#### 🗄️ تغییرات دیتابیس

سه فیلد جدید به جدول `pays` اضافه شد:

| فیلد | نوع | توضیحات |
|------|-----|---------|
| `fish_photo_id` | varchar(500) | شناسه فایل تلگرام (عکس، سند، ویدیو) |
| `fish_type` | varchar(50) | نوع فیش: photo, document, video, text |
| `fish_caption` | text | متن توضیحات فیش (شماره پیگیری، ساعت، نام) |

#### 📱 قابلیت‌های جدید

##### الف) ذخیره اطلاعات فیش
هنگامی که کاربر فیش واریزی ارسال می‌کند:
- عکس، سند، ویدیو یا متن در دیتابیس ذخیره می‌شود
- حتی اگر سفارش کنسل شود، فیش همچنان قابل مشاهده است

##### ب) نمایش فیش در لیست
در صفحه **مدیریت فیش‌های در انتظار**:
```
1. 👤 1234567890
   📦 50GB - 1 کاربره - 30 روزه
   💰 50,000 تومان
   📅 1403/09/05 14:30
   📝 شماره پیگیری: 123456 - ساعت 14:25 - نام: احمد

✅ تایید #1    ❌ رد #1
🔍 مشاهده فیش #1
```

##### ج) مشاهده جزئیات فیش
با کلیک روی **🔍 مشاهده فیش**:
- عکس فیش به همراه کپشن ارسال می‌شود
- اطلاعات کامل سفارش نمایش داده می‌شود
- دکمه‌های تایید/رد مستقیم در همان صفحه

#### 🔧 فایل‌های تغییر یافته
1. `vip_plans_handler.php`:
   - ذخیره فیش در دیتابیس (خط ~510)
   - نمایش متن فیش در لیست (خط ~1114)
   - دکمه مشاهده فیش (خط ~1125)
   - تابع مشاهده فیش کامل (خط ~1285)

2. `createTables.php`:
   - افزودن فیلدهای جدید به جدول pays

---

## 🚀 نحوه نصب

### گام 1: بروزرسانی دیتابیس

برای اضافه کردن فیلدهای جدید به جدول `pays`:

```
http://your-domain.com/update_pays_table.php
```

یا به صورت دستی SQL زیر را اجرا کنید:

```sql
ALTER TABLE `pays` ADD COLUMN `fish_photo_id` varchar(500) DEFAULT NULL AFTER `agent_count`;
ALTER TABLE `pays` ADD COLUMN `fish_type` varchar(50) DEFAULT NULL AFTER `fish_photo_id`;
ALTER TABLE `pays` ADD COLUMN `fish_caption` text DEFAULT NULL AFTER `fish_type`;
```

### گام 2: آپلود فایل‌ها

فایل‌های زیر را جایگزین کنید:
- ✅ `discount_system.php`
- ✅ `vip_plans_handler.php`
- ✅ `createTables.php`

فایل‌های جدید:
- ➕ `update_pays_table.php`

### گام 3: تست عملکرد

1. وارد ربات شوید و دکمه **🎁 کد تخفیف** را بزنید
2. بررسی کنید که سرویس‌های عادی حذف شده باشند
3. راهنمای hint را ببینید
4. یک سفارش تست کنید و فیش ارسال کنید
5. از پنل ادمین وارد **💳 مدیریت فیش‌های در انتظار** شوید
6. روی **🔍 مشاهده فیش** کلیک کنید

---

## 🎯 مزایای این آپدیت

### ✨ برای ادمین:
- ✅ مشاهده فیش واریزی حتی بعد از کنسل شدن سفارش
- ✅ دسترسی سریع به اطلاعات پرداخت
- ✅ امکان بررسی دقیق‌تر سفارشات
- ✅ کاهش خطا در تایید فیش‌ها

### ✨ برای کاربر:
- ✅ راهنمای واضح‌تر برای انتخاب سرویس
- ✅ منوی ساده‌تر و کاربردی‌تر
- ✅ تمرکز روی پلن‌های اصلی (VIP و Trading)

---

## 📊 نمونه عملکرد

### قبل از آپدیت:
```
💳 مدیریت فیش‌های در انتظار

1. 👤 1234567890
   📦 50GB - 30 روزه
   💰 50,000 تومان

✅ تایید #1    ❌ رد #1
```

### بعد از آپدیت:
```
💳 مدیریت فیش‌های در انتظار

1. 👤 1234567890
   📦 50GB - 1 کاربره - 30 روزه
   💰 50,000 تومان
   📅 1403/09/05 14:30
   📝 شماره پیگیری: 123456

✅ تایید #1    ❌ رد #1
🔍 مشاهده فیش #1
```

کلیک روی "مشاهده فیش":
```
[عکس فیش واریزی]

🔍 فیش واریزی

━━━━━━━━━━━━━━━━━━━━━━
👤 کاربر: 1234567890
🔋 حجم: 50 گیگ
⏰ مدت: 30 روز
💰 مبلغ: 50,000 تومان
📅 تاریخ: 1403/09/05 14:30
━━━━━━━━━━━━━━━━━━━━━━

📝 اطلاعات پرداخت:
شماره پیگیری: 123456
ساعت: 14:25
نام پرداخت کننده: احمد

✅ تایید و ارسال کانفیگ    ❌ رد کردن
🔙 بازگشت به لیست
```

---

## ⚠️ نکات مهم

1. **پشتیبان بگیرید**: قبل از نصب حتماً از دیتابیس و فایل‌ها backup بگیرید

2. **فیلدهای قدیمی**: فیش‌هایی که قبل از این آپدیت ارسال شده‌اند، این فیلدها خالی هستند

3. **حجم فایل**: فایل‌های تلگرام به صورت file_id ذخیره می‌شوند (بدون اشغال فضا)

4. **امنیت**: فقط ادمین‌ها می‌توانند فیش‌ها را مشاهده کنند

---

## 🐛 عیب‌یابی

### مشکل: فیش‌ها نمایش داده نمی‌شوند
**راه حل:**
1. بررسی کنید `update_pays_table.php` اجرا شده باشد
2. از phpMyAdmin بررسی کنید فیلدهای جدید در جدول `pays` وجود دارند

### مشکل: دکمه "مشاهده فیش" نمایش داده نمی‌شود
**علت:** فقط برای فیش‌هایی که عکس/سند/ویدیو دارند نمایش داده می‌شود

### مشکل: سرویس‌های عادی هنوز نمایش داده می‌شوند
**راه حل:** مطمئن شوید فایل `discount_system.php` جایگزین شده است

---

## 📞 پشتیبانی

برای هرگونه مشکل یا سوال:
- فایل `test_features.php` را باز کنید
- وضعیت دیتابیس را بررسی کنید
- لاگ‌های خطا را چک کنید

---

**نسخه:** 2.2  
**تاریخ:** 1403/09/05  
**سازگار با:** نسخه 2.0 و بالاتر
