# 🔥 راهنمای کامل تست گردش کار VIP

## ✅ تغییرات انجام شده

### 1. رفع مشکل دریافت رسید پرداخت
- ✅ اکنون **عکس** (photo) به درستی دریافت می‌شود
- ✅ اکنون **فایل/سند** (document, PDF) به درستی دریافت می‌شود  
- ✅ اکنون **ویدیو** (video) به درستی دریافت می‌شود
- ✅ اکنون **متن** (شماره پیگیری، ساعت، نام) به درستی دریافت می‌شود
- ✅ ارسال به ادمین بر اساس نوع فایل صحیح انجام می‌شود

### 2. رفع مشکل منوی تایید ادمین
- ✅ callback `approveVipPay` به درستی کار می‌کند
- ✅ بعد از تایید، پیام به ادمین ارسال می‌شود با راهنمای کامل
- ✅ step به درستی تنظیم می‌شود (`sendVipConfig_{hash_id}`)
- ✅ دکمه لغو برای ادمین فعال است

### 3. رفع مشکل دریافت و ارسال کانفیگ
- ✅ لینک کانفیگ به درستی validate می‌شود
- ✅ لینک در دیتابیس ذخیره می‌شود
- ✅ سفارش به جدول `orders_list` اضافه می‌شود (برای سرویس‌های من)
- ✅ تاریخ انقضا به درستی محاسبه می‌شود
- ✅ تاریخ به شمسی تبدیل می‌شود
- ✅ پیام زیبا و کامل به کاربر ارسال می‌شود
- ✅ پیام گزارش به ادمین ارسال می‌شود

---

## 📝 مسیر کامل گردش کار

### مرحله 1: انتخاب پلن توسط مشتری
```
کاربر روی "پلن‌های VIP" کلیک می‌کند
↓
لیست 8 پلن نمایش داده می‌شود
↓
کاربر یک پلن را انتخاب می‌کند (مثلا vip1)
↓
جزئیات پلن + دکمه "پرداخت کارت به کارت" نمایش داده می‌شود
```

### مرحله 2: شروع پرداخت
```
کاربر روی "💳 پرداخت کارت به کارت" کلیک می‌کند
↓
اطلاعات در جدول `pays` با state='pending' ذخیره می‌شود
↓
پیام شامل شماره کارت + مبلغ به کاربر ارسال می‌شود
↓
step کاربر = 'vipCartPay_{hash_id}' تنظیم می‌شود
```

### مرحله 3: ارسال رسید توسط مشتری
```
کاربر یکی از این‌ها را ارسال می‌کند:
  - عکس رسید (با یا بدون caption)
  - فایل PDF رسید
  - متن (شماره پیگیری + ساعت + نام)
↓
ربات رسید را دریافت می‌کند (✅ اکنون همه نوع‌ها کار می‌کند)
↓
رسید + اطلاعات سفارش به ادمین ارسال می‌شود
↓
دکمه‌های "✅ تایید" و "❌ رد" برای ادمین نمایش داده می‌شود
↓
پیام تایید به کاربر: "سفارشت ثبت شد، منتظر تایید باش"
```

### مرحله 4: تایید توسط ادمین
```
ادمین روی "✅ تایید و ارسال کانفیگ" کلیک می‌کند
↓
state سفارش = 'approved' می‌شود
↓
step ادمین = 'sendVipConfig_{hash_id}' تنظیم می‌شود
↓
پیام راهنما به ادمین: "لطفا لینک کانفیگ را ارسال کنید"
↓
دکمه لغو برای ادمین نمایش داده می‌شود
```

### مرحله 5: ارسال کانفیگ توسط ادمین
```
ادمین لینک کانفیگ را می‌فرستد (یکی از این‌ها):
  - http://apn.lotfischool.ir:2096/sub/...
  - vless://...
  - vmess://...
  - trojan://...
↓
ربات لینک را validate می‌کند (✅ regex pattern بهبود یافته)
↓
اگر معتبر بود:
  1. لینک در جدول `pays` (فیلد payid) ذخیره می‌شود
  2. state = 'completed' می‌شود
  3. یک رکورد در `orders_list` ایجاد می‌شود:
     - userid = کاربر
     - token = یک token تصادفی 30 کاراکتری
     - transid = hash_id
     - remark = VIP_{8 کاراکتر اول hash}
     - expire_date = زمان فعلی + (days × 24 × 60 × 60)
     - link = لینک کانفیگ
     - amount = قیمت
     - date = زمان فعلی
  4. تاریخ خرید و انقضا به شمسی تبدیل می‌شود
↓
پیام زیبا و کامل به کاربر ارسال می‌شود شامل:
  - نام پلن
  - حجم
  - مدت
  - قیمت
  - تاریخ خرید (شمسی)
  - تاریخ انقضا (شمسی)
  - لینک کانفیگ
  - راهنمای اتصال
  - اعلام ذخیره در "سرویس‌های من"
↓
پیام گزارش به ادمین ارسال می‌شود با خلاصه عملیات
```

---

## 🧪 نحوه تست

### تست 1: ارسال عکس رسید
1. به عنوان کاربر یک پلن VIP انتخاب کنید
2. روی "پرداخت کارت به کارت" کلیک کنید  
3. یک **عکس** (مثلا اسکرین‌شات) بفرستید
4. ✅ باید به ادمین برسد با عکس

### تست 2: ارسال فایل PDF رسید
1. همان مراحل بالا
2. یک **فایل PDF** بفرستید
3. ✅ باید به ادمین برسد با فایل

### تست 3: ارسال متن رسید
1. همان مراحل بالا
2. فقط **متن** بنویسید مثل: "شماره پیگیری: 123456 - ساعت: 14:30 - نام: علی"
3. ✅ باید به ادمین برسد با متن

### تست 4: تایید و ارسال کانفیگ
1. به عنوان ادمین روی "✅ تایید و ارسال کانفیگ" کلیک کنید
2. ✅ باید پیام راهنما دریافت کنید
3. یک لینک کانفیگ بفرستید (مثلا: `vless://test123...`)
4. ✅ کاربر باید کانفیگ را دریافت کند
5. ✅ سفارش باید در "سرویس‌های من" کاربر نمایش داده شود

### تست 5: لینک نامعتبر
1. به عنوان ادمین لینک را تایید کنید
2. یک متن بی‌معنی بفرستید (مثلا: "این یک تست است")
3. ✅ باید پیام خطا دریافت کنید و درخواست لینک مجدد شود

### تست 6: لغو توسط ادمین
1. به عنوان ادمین لینک را تایید کنید
2. روی دکمه "❌ لغو" کلیک کنید
3. ✅ سفارش به حالت pending برگردد

---

## 🐛 رفع مشکلات احتمالی

### اگر رسید به ادمین نرسید:
1. چک کنید که `$admin` در config.php تنظیم شده باشد
2. لاگ خطاها را بررسی کنید
3. مطمئن شوید که ربات پیام‌ها را دریافت می‌کند

### اگر بعد از تایید اتفاقی نیفتاد:
1. چک کنید که callback_data به درستی تنظیم شده باشد
2. مطمئن شوید step ادمین به درستی ست می‌شود
3. لاگ دیتابیس را چک کنید

### اگر کانفیگ ارسال نشد:
1. مطمئن شوید لینک با یکی از پروتکل‌های مجاز شروع می‌شود
2. چک کنید که state سفارش 'approved' باشد
3. مطمئن شوید جدول `orders_list` دسترسی INSERT دارد

---

## 📊 جداول دیتابیس مرتبط

### جدول `pays`
- `hash_id`: شناسه یکتای سفارش
- `user_id`: آیدی کاربر  
- `type`: 'vip'
- `description`: نام پلن
- `volume`: حجم (گیگ)
- `day`: مدت (روز)
- `price`: قیمت (تومان)
- `state`: pending → approved → completed
- `payid`: لینک کانفیگ (بعد از تایید)
- `agent_count`: تعداد کاربر (1 یا 2)

### جدول `orders_list`
- `userid`: آیدی کاربر
- `token`: توکن یکتا
- `transid`: hash_id از pays
- `remark`: VIP_{hash}
- `protocol`: 'vless'
- `expire_date`: timestamp انقضا
- `link`: لینک کانفیگ
- `amount`: قیمت
- `status`: 1 (فعال)
- `date`: زمان خرید

---

## 🎯 خلاصه تغییرات کلیدی

1. ✅ **دریافت رسید**: از `$message` به `$update->message` تغییر داده شد
2. ✅ **نوع فایل**: متغیر `$file_type` برای شناسایی نوع رسید اضافه شد
3. ✅ **ارسال به ادمین**: شرط‌های جداگانه برای photo/document/video/text
4. ✅ **callback تایید**: از `delMessage()` به `Bot('deleteMessage')` تغییر کرد
5. ✅ **step ادمین**: به روش صحیح با UPDATE query تنظیم می‌شود
6. ✅ **validation لینک**: regex بهبود یافت (hysteria2 اضافه شد)
7. ✅ **تاریخ**: از `$time` گلوبال به `time()` و `$current_time` تغییر کرد
8. ✅ **token**: برای orders_list اضافه شد
9. ✅ **پیام‌ها**: تمام پیام‌ها بهبود یافت و اطلاعات کامل‌تر شد

---

## 🚀 توصیه‌های بعدی

1. افزودن QR Code برای لینک کانفیگ
2. افزودن گزینه "دانلود کانفیگ" برای کاربر
3. ارسال یادآور قبل از انقضا
4. پنل مدیریت سفارشات VIP برای ادمین
5. امکان تمدید خودکار

---

تمام تغییرات با موفقیت انجام شد! ✅
