# 🚀 راهنمای نصب ویژگی‌های جدید ربات APN

## ✨ ویژگی‌های اضافه شده

### 1️⃣ سیستم نوتیفیکیشن هوشمند
- ✅ اعلان 7، 3، 1 روز قبل از اتمام سرویس
- ✅ اعلان سرویس‌های منقضی شده
- ✅ پیام خوشامدگویی حرفه‌ای
- ✅ نوتیفیکیشن خرید موفق

### 2️⃣ سیستم کد تخفیف پیشرفته
- ✅ کد تخفیف مبلغ ثابت یا درصدی
- ✅ محدودیت تاریخ و تعداد استفاده
- ✅ پنل مدیریت کامل برای ادمین
- ✅ ردیابی استفاده کاربران

### 3️⃣ گزارش‌دهی پیشرفته
- ✅ داشبورد آمار کامل (درآمد، کاربران، فروش)
- ✅ نمودار فروش 7 روز
- ✅ تحلیل کاربران و CLTV
- ✅ آمار کدهای تخفیف

---

## 📦 فایل‌های جدید

```
📁 robotali/
├── 📄 notification_system.php      (سیستم نوتیفیکیشن)
├── 📄 discount_system.php          (سیستم کد تخفیف)
├── 📄 advanced_reports.php         (گزارش‌دهی)
├── 📄 cron_notifications.php       (Cron Job)
└── 📄 INSTALLATION_GUIDE.md        (این فایل)
```

---

## 🔧 مراحل نصب

### مرحله 1: آپلود فایل‌ها ✅

تمام فایل‌های جدید را در پوشه اصلی ربات آپلود کنید:
```
/home/username/public_html/
```

### مرحله 2: تنظیم Cron Job ⏰

#### روش 1: از طریق cPanel

1. وارد cPanel شوید
2. بخش **Cron Jobs** را باز کنید
3. یک Cron Job جدید با تنظیمات زیر اضافه کنید:

```bash
# هر 6 ساعت یکبار اجرا می‌شود
0 */6 * * * /usr/bin/php /home/username/public_html/cron_notifications.php

# یا برای اجرای هر 4 ساعت:
0 */4 * * * /usr/bin/php /home/username/public_html/cron_notifications.php
```

#### روش 2: از طریق URL (اگر دسترسی SSH ندارید)

1. فایل `cron_notifications.php` را ویرایش کنید
2. کلید امنیتی را تغییر دهید:
```php
define('CRON_SECRET_KEY', 'YOUR_RANDOM_SECRET_KEY_HERE');
```

3. از سرویس‌های Cron رایگان مثل:
   - https://cron-job.org
   - https://easycron.com

4. URL زیر را اضافه کنید:
```
https://lotfisch.ir/cron_notifications.php?key=YOUR_SECRET_KEY
```

### مرحله 3: تست Cron Job 🧪

برای تست دستی، این URL را در مرورگر باز کنید:
```
https://lotfisch.ir/cron_notifications.php?key=YOUR_SECRET_KEY
```

اگر پیام زیر را دیدید، همه چیز درست کار می‌کند:
```
✅ چک نوتیفیکیشن انجام شد
✅ چک سرویس‌های منقضی شده انجام شد
```

---

## 🎯 نحوه استفاده

### برای ادمین:

#### ایجاد کد تخفیف:
1. ربات را باز کنید
2. **مدیریت ربات ⚙️** → **🎁 مدیریت کدهای تخفیف**
3. **➕ ایجاد کد تخفیف**
4. مراحل را طی کنید:
   - نام کد (مثلاً `WELCOME10`)
   - نوع تخفیف (ثابت یا درصدی)
   - مقدار تخفیف
   - تاریخ انقضا
   - تعداد استفاده

#### مشاهده آمار پیشرفته:
1. **مدیریت ربات ⚙️**
2. **📊 داشبورد آمار پیشرفته**
3. مشاهده:
   - درآمد (امروز، هفته، ماه)
   - کاربران جدید
   - نمودار فروش
   - بهترین مشتریان
   - عملکرد کدهای تخفیف

### برای کاربر:

#### استفاده از کد تخفیف:
1. منوی اصلی → **🎁 کد تخفیف**
2. کد تخفیف را وارد کنید (مثلاً `WELCOME10`)
3. یک سرویس خریداری کنید
4. تخفیف به صورت خودکار اعمال می‌شود

#### دریافت نوتیفیکیشن:
- ربات به صورت خودکار:
  - 7 روز قبل از اتمام سرویس یادآوری می‌فرستد
  - 3 روز قبل از اتمام
  - 1 روز قبل از اتمام
  - وقتی سرویس منقضی شد

---

## 🔍 عیب‌یابی

### مشکل: Cron Job کار نمی‌کند

**راه حل 1:**
```bash
# بررسی مسیر PHP
which php
# خروجی: /usr/bin/php یا /usr/local/bin/php

# Cron را با مسیر صحیح تنظیم کنید
```

**راه حل 2:**
```bash
# استفاده از wget به جای PHP
*/6 * * * * wget -q -O - "https://lotfisch.ir/cron_notifications.php?key=YOUR_KEY" > /dev/null 2>&1
```

### مشکل: کد تخفیف اعمال نمی‌شود

1. چک کنید کد فعال باشد (در پنل ادمین)
2. تاریخ انقضا را بررسی کنید
3. تعداد استفاده را چک کنید
4. ببینید کاربر قبلاً استفاده کرده یا نه

### مشکل: نوتیفیکیشن ارسال نمی‌شود

1. فایل لاگ را بررسی کنید:
```bash
cat /home/username/public_html/cron_log.txt
```

2. مجوز فایل‌ها را چک کنید:
```bash
chmod 644 notification_system.php
chmod 644 cron_notifications.php
```

---

## 📊 مشاهده لاگ‌ها

لاگ Cron Job در فایل `cron_log.txt` ذخیره می‌شود:

```bash
# مشاهده آخرین 50 خط
tail -n 50 cron_log.txt

# مشاهده همه لاگ‌ها
cat cron_log.txt

# پاک کردن لاگ‌ها (اگر خیلی بزرگ شد)
> cron_log.txt
```

---

## 🎨 سفارشی‌سازی

### تغییر متن پیام‌ها:

فایل `notification_system.php` را ویرایش کنید و پیام‌ها را تغییر دهید:

```php
$message = "⏰ یادآوری اتمام سرویس
...
";
```

### تغییر فاصله نوتیفیکیشن:

در `notification_system.php`:
```php
// به جای 7 روز، 10 روز
$seven_days = $now + (10 * 24 * 60 * 60);
```

### اضافه کردن فیلد به آمار:

در `advanced_reports.php` کوئری‌های SQL را تغییر دهید.

---

## 📞 پشتیبانی

اگر مشکلی داشتید:
1. ابتدا بخش **عیب‌یابی** را بخوانید
2. فایل لاگ را بررسی کنید
3. با توسعه‌دهنده تماس بگیرید

---

## 🔄 بروزرسانی‌های آینده

### ویژگی‌های در دست توسعه:
- [ ] پنل کاربری تحت وب
- [ ] اپلیکیشن موبایل
- [ ] سیستم تیکت پیشرفته‌تر
- [ ] یکپارچه‌سازی با CRM
- [ ] گزارش PDF
- [ ] نمودارهای تعاملی

---

**نسخه:** 2.0.0  
**تاریخ:** نوامبر 2025  
**سازنده:** APN Development Team

✅ **همه چیز آماده است! ربات شما حالا حرفه‌ای‌تر شده 🚀**
