# 🔧 راهنمای رفع مشکل ربات

## مشکل: ربات بعد از /start جواب نمی‌دهد

### مراحل رفع مشکل:

## 🎯 مرحله 1: اجرای اسکریپت رفع مشکل خودکار

به آدرس زیر بروید:
```
https://apnlot.ir/robotali/fix_bot.php
```

این اسکریپت به طور خودکار:
- ✅ Webhook قدیمی را حذف می‌کند
- ✅ آپدیت‌های معلق را پاک می‌کند  
- ✅ Webhook جدید را تنظیم می‌کند
- ✅ یک پیام تست به شما ارسال می‌کند

---

## 🔍 مرحله 2: بررسی وضعیت ربات

به آدرس زیر بروید:
```
https://apnlot.ir/robotali/test_bot.php
```

این صفحه نشان می‌دهد:
- وضعیت اتصال به API تلگرام
- وضعیت اتصال به دیتابیس
- وضعیت Webhook
- وجود فایل‌های ضروری

---

## 🧪 مرحله 3: تست مستقیم

به آدرس زیر بروید:
```
https://apnlot.ir/robotali/direct_test.php
```

این فایل:
- تمام فایل‌های ضروری را لود می‌کند
- یک پیام تست به شما ارسال می‌کند
- خطاهای احتمالی را نشان می‌دهد

---

## 🐛 مرحله 4: دیباگ پیشرفته (اگر هنوز کار نکرد)

### 4-1: تنظیم Debug Webhook

در مرورگر باز کنید:
```
https://apnlot.ir/robotali/setDebugWebhook.php
```

یا دستی تنظیم کنید:
```
https://api.telegram.org/bot8229815851:AAFOkuuP775Mf67MWTPGci3UZboDd7WNcOs/setWebhook?url=https://apnlot.ir/robotali/debug_webhook.php
```

### 4-2: ارسال /start در تلگرام

به ربات خود در تلگرام بروید و `/start` را ارسال کنید

### 4-3: بررسی لاگ

فایل `debug_log.txt` را باز کنید:
```
https://apnlot.ir/robotali/debug_log.txt
```

اگر خالی بود، یعنی درخواست به سرور نمی‌رسد

---

## ⚠️ مشکلات رایج و راه‌حل‌ها

### مشکل 1: Webhook تنظیم نمی‌شود
**علت**: مشکل SSL یا دسترسی به دامنه  
**راه‌حل**: 
- بررسی کنید دامنه شما SSL دارد (https)
- مطمئن شوید فایل `bot.php` در مسیر صحیح است

### مشکل 2: خطای 500
**علت**: خطای PHP در کد  
**راه‌حل**:
- فایل `error_log` را در پوشه `settings` بررسی کنید
- در `baseInfo.php` گزینه `display_errors` را روشن کنید

### مشکل 3: اتصال به دیتابیس
**علت**: اطلاعات دیتابیس اشتباه است  
**راه‌حل**:
- فایل `baseInfo.php` را بررسی کنید
- مطمئن شوید دیتابیس ساخته شده است

### مشکل 4: ربات بلاک شده
**علت**: احتمالاً توسط کاربر بلاک شده  
**راه‌حل**:
- ربات را در تلگرام unblock کنید
- دستور `/start` را مجدد ارسال کنید

---

## ✅ بررسی نهایی

بعد از اجرای مراحل بالا، این موارد را چک کنید:

1. ✅ `test_bot.php` همه چیز سبز است
2. ✅ `fix_bot.php` اجرا شد بدون خطا
3. ✅ پیام تست از `direct_test.php` دریافت شد
4. ✅ در تلگرام `/start` پاسخ می‌دهد

---

## 📞 اگر هنوز مشکل دارید

1. لاگ `debug_log.txt` را بررسی کنید
2. لاگ `settings/error_log` را بررسی کنید
3. با دستور زیر وضعیت webhook را ببینید:

```
https://api.telegram.org/bot8229815851:AAFOkuuP775Mf67MWTPGci3UZboDd7WNcOs/getWebhookInfo
```

---

## 🔄 ریست کامل (آخرین راه‌حل)

اگر هیچ کدام کار نکرد:

```php
// 1. حذف webhook
https://api.telegram.org/bot8229815851:AAFOkuuP775Mf67MWTPGci3UZboDd7WNcOs/deleteWebhook

// 2. صبر کنید 10 ثانیه

// 3. تنظیم دوباره
https://apnlot.ir/robotali/setWebhook.php

// 4. تست
https://apnlot.ir/robotali/test_bot.php
```

---

موفق باشید! 🚀
