# 🎯 چک‌لیست نهایی استقرار

## ✅ فایل‌های آماده آپلود

### 📁 فایل‌های ضروری (باید آپلود شوند):
```
✅ bot.php (401 KB) - ویرایش شده
✅ config.php (196 KB) - ویرایش شده
✅ server_manager.php (18 KB) - جدید
✅ service_creator.php (14 KB) - جدید
✅ install_new_system.php (10 KB) - جدید
```

### 📁 فایل‌های مدیریتی (بدون تغییر):
```
✅ trading_plans_handler.php
✅ notification_system.php
✅ discount_system.php
✅ advanced_reports.php
✅ baseInfo.php
✅ createDB.php
✅ createTables.php
```

---

## 🗑️ فایل‌های حذف شده

### ❌ فایل‌های PHP قدیمی:
- ✅ vip_plans_handler.php
- ✅ auto_account_creator.php
- ✅ account_manager.php
- ✅ vip_manual_config_handler.php
- ✅ install_vip_auto_system.php
- ✅ test*.php (8 فایل تست)

### ❌ فایل‌های مستندات قدیمی:
- ✅ CHANGELOG_VIP.md
- ✅ SUMMARY_VIP_AUTO_SYSTEM.md
- ✅ SUMMARY_VIP_SALES.md
- ✅ TEST_VIP_FLOW.md
- ✅ VIP_AUTO_INSTALL_GUIDE.md
- ✅ VPS_API_INSTALL_GUIDE.md
- ✅ UPDATE_2.1.md

### ❌ فایل‌های راهنمای فارسی قدیمی:
- ✅ تغییرات_VIP_جدید.txt
- ✅ راهنمای_ارسال_کانفیگ_حرفه_ای.txt
- ✅ راهنمای_پلن_های_VIP.txt
- ✅ راهنمای_کامل_VIP_آپدیت_شده.txt
- ✅ FILES_TO_DELETE.txt
- ✅ FILES_TO_UPLOAD.txt

---

## 🚀 مراحل استقرار

### مرحله 1: آپلود فایل‌ها
```bash
📤 آپلود به: https://apnlot.ir/robotali/

فایل‌های ضروری:
1. bot.php (جایگزین نسخه قدیمی)
2. config.php (جایگزین نسخه قدیمی)
3. server_manager.php (جدید)
4. service_creator.php (جدید)
5. install_new_system.php (جدید)
```

### مرحله 2: اجرای نصب دیتابیس
```
🌐 مرورگر: https://apnlot.ir/robotali/install_new_system.php

انتظار خروجی:
✅ جدول servers ایجاد شد
✅ جدول plan_categories ایجاد شد
✅ جدول service_plans ایجاد شد
✅ جدول service_orders ایجاد شد
✅ جدول temp_service_purchases ایجاد شد
✅ سرور آلمان اضافه شد (ID: 1)
✅ 3 دسته‌بندی اضافه شد
✅ 8 تعرفه اضافه شد
```

### مرحله 3: حذف فایل‌های قدیمی از هاست
```
❌ حذف از cPanel File Manager:
- vip_plans_handler.php
- auto_account_creator.php
- account_manager.php
- vip_manual_config_handler.php
- install_vip_auto_system.php
- تمام فایل‌های test*.php
```

### مرحله 4: تست سیستم
```
1️⃣ باز کردن ربات در تلگرام
2️⃣ کلیک روی "🔥 خرید سرویس VPN"
3️⃣ انتخاب "پلن‌های یک ماهه 📅"
4️⃣ مشاهده لیست 5 تعرفه (20گیگ تا نامحدود)
5️⃣ کلیک روی "🛒 خرید 20 گیگ یک ماهه"
6️⃣ انتخاب "💳 پرداخت از کیف پول"
7️⃣ بررسی ساخت اتوماتیک سرویس
8️⃣ دریافت کانفیگ
```

### مرحله 5: تست پنل ادمین
```
1️⃣ کلیک "مدیریت ربات ⚙️"
2️⃣ کلیک "🖥️ مدیریت سرورها"
3️⃣ مشاهده "سرور آلمان VIP 🇩🇪"
4️⃣ کلیک "➕ افزودن سرور جدید"
5️⃣ وارد کردن اطلاعات سرور دوم
6️⃣ ذخیره و بررسی
```

---

## 🔍 تست‌های توصیه شده

### ✔️ تست 1: خرید با کیف پول
```
موجودی: 50,000 تومان
تعرفه: 20 گیگ یک ماهه (40,000 تومان)
انتظار: ساخت اتوماتیک + ارسال کانفیگ
```

### ✔️ تست 2: خرید با فیش
```
تعرفه: 35 گیگ یک ماهه (55,000 تومان)
ارسال: عکس فیش بانکی
انتظار: پیام به ادمین + تایید + ساخت اتوماتیک
```

### ✔️ تست 3: افزودن سرور
```
نام: سرور هلند 🇳🇱
IP: 185.x.x.x
پورت: 2083
مسیر: /xui-panel
انتظار: ذخیره موفق + نمایش در لیست
```

### ✔️ تست 4: افزودن تعرفه
```
دسته: پلن‌های یک ماهه
سرور: سرور آلمان
نام: 100 گیگ یک ماهه 🚀
حجم: 100
مدت: 30 روز
قیمت: 120000 تومان
انتظار: ظاهر شدن در لیست خرید
```

---

## 🎯 نکات مهم

### ⚠️ قبل از استقرار:
1. ✅ بکاپ کامل از فایل‌های قدیمی
2. ✅ بکاپ کامل از دیتابیس
3. ✅ یادداشت اطلاعات مهم (API keys, admin ID, bot token)

### ⚠️ بعد از استقرار:
1. ✅ تست خرید یک سرویس واقعی
2. ✅ بررسی لاگ‌ها: `logs/service_creation_[DATE].log`
3. ✅ بررسی جدول `service_orders`
4. ✅ حذف `install_new_system.php` از هاست (امنیت)

### ⚠️ عیب‌یابی:
```
📁 لاگ‌ها: robotali/logs/
🗄️ دیتابیس: phpMyAdmin > lotfisch_qq
🌐 API: http://82.115.26.209/api/create_vip_account.php
```

---

## 📊 وضعیت نهایی

### ✅ آماده استقرار:
- [x] کد بدون خطا
- [x] فایل‌های قدیمی حذف شده
- [x] مستندات آماده
- [x] راهنمای استقرار کامل

### 🎉 ویژگی‌های جدید:
- [x] مدیریت چند سرور
- [x] دسته‌بندی دینامیک
- [x] تعرفه‌های قابل تنظیم
- [x] ساخت اتوماتیک سرویس
- [x] پرداخت از کیف پول
- [x] پرداخت با فیش بانکی
- [x] لیست سرویس‌های من
- [x] لاگ کامل عملیات

---

## 🔗 لینک‌های مفید

- 🤖 ربات: https://t.me/YOUR_BOT_USERNAME
- 🌐 هاست: https://apnlot.ir/robotali/
- 🖥️ VPS: 82.115.26.209
- 📡 X-UI: https://127.0.0.1:2083/aHfvIoyNWcxlOfBfje

---

**✅ همه چیز آماده است! می‌توانید استقرار را شروع کنید.**

📅 تاریخ: 29 نوامبر 2025
🔧 سازنده: @NoovixCo
