<?php
/**
 * چک کننده نهایی - تشخیص دقیق مشکل
 */
header('Content-Type: text/html; charset=utf-8');
include "config.php";

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset='UTF-8'>
    <title>چک کننده نهایی</title>
    <style>
        *{margin:0; padding:0; box-sizing:border-box;}
        body{font-family:'Segoe UI',Tahoma,Arial; direction:rtl; background:linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding:20px; min-height:100vh;}
        .container{max-width:1000px; margin:0 auto;}
        h1{color:white; text-align:center; font-size:42px; margin-bottom:30px; text-shadow:2px 2px 4px rgba(0,0,0,0.3);}
        .card{background:white; border-radius:15px; padding:25px; margin:20px 0; box-shadow:0 10px 30px rgba(0,0,0,0.3);}
        .check-item{padding:15px; margin:10px 0; border-radius:8px; border-right:5px solid #ccc; display:flex; align-items:center; justify-content:space-between;}
        .check-item.pass{background:#e8f5e9; border-right-color:#4caf50;}
        .check-item.fail{background:#ffebee; border-right-color:#f44336;}
        .check-item.warning{background:#fff3e0; border-right-color:#ff9800;}
        .icon{font-size:24px; margin-left:15px;}
        .detail{font-size:13px; color:#666; margin-top:5px;}
        button{background:#667eea; color:white; border:none; padding:15px 30px; border-radius:8px; font-size:16px; cursor:pointer; margin:10px 5px;}
        button:hover{background:#764ba2;}
        .critical-box{background:#d32f2f; color:white; padding:20px; border-radius:10px; margin:20px 0; font-size:18px; font-weight:bold;}
        .success-box{background:#4caf50; color:white; padding:20px; border-radius:10px; margin:20px 0; font-size:18px; font-weight:bold;}
        pre{background:#263238; color:#aed581; padding:15px; border-radius:8px; overflow-x:auto; font-size:12px; margin:10px 0;}
        .step-badge{background:#667eea; color:white; padding:5px 15px; border-radius:20px; font-weight:bold; display:inline-block; margin-bottom:15px;}
    </style>
</head>
<body>
<div class='container'>
    <h1>🔍 چک کننده نهایی سیستم</h1>
    
    <?php
    $errors = [];
    $warnings = [];
    $success_count = 0;
    $total_checks = 0;
    
    // تابع کمکی برای چک
    function check($condition, $message, $detail = ''){
        global $errors, $warnings, $success_count, $total_checks;
        $total_checks++;
        
        if($condition === true){
            $success_count++;
            echo "<div class='check-item pass'>";
            echo "<div><span class='icon'>✅</span> {$message}";
            if($detail) echo "<div class='detail'>{$detail}</div>";
            echo "</div></div>";
            return true;
        } else if($condition === 'warning'){
            $warnings[] = $message;
            echo "<div class='check-item warning'>";
            echo "<div><span class='icon'>⚠️</span> {$message}";
            if($detail) echo "<div class='detail'>{$detail}</div>";
            echo "</div></div>";
            return false;
        } else {
            $errors[] = $message;
            echo "<div class='check-item fail'>";
            echo "<div><span class='icon'>❌</span> {$message}";
            if($detail) echo "<div class='detail'>{$detail}</div>";
            echo "</div></div>";
            return false;
        }
    }
    
    // ============ چک 1: دیتابیس ============
    echo "<div class='card'>";
    echo "<div class='step-badge'>مرحله 1</div>";
    echo "<h2>🗄️ بررسی دیتابیس</h2>";
    
    $pays_check = $connection->query("SHOW TABLES LIKE 'pays'");
    check($pays_check && $pays_check->num_rows > 0, "جدول pays موجود است");
    
    if($pays_check && $pays_check->num_rows > 0){
        $cols = [];
        $col_result = $connection->query("SHOW COLUMNS FROM pays");
        while($col = $col_result->fetch_assoc()){
            $cols[] = $col['Field'];
        }
        
        check(in_array('user_id', $cols), "ستون user_id در pays موجود است", "ستون‌ها: " . implode(', ', $cols));
        check(in_array('hash_id', $cols), "ستون hash_id در pays موجود است");
        check(in_array('price', $cols), "ستون price در pays موجود است");
        check(in_array('photo', $cols), "ستون photo در pays موجود است");
    }
    
    $users_check = $connection->query("SHOW TABLES LIKE 'users'");
    check($users_check && $users_check->num_rows > 0, "جدول users موجود است");
    
    $plans_check = $connection->query("SELECT COUNT(*) as cnt FROM service_plans WHERE status='active'");
    $plan_count = $plans_check->fetch_assoc()['cnt'];
    check($plan_count > 0, "پلن‌های فعال موجود است", "تعداد: {$plan_count}");
    
    echo "</div>";
    
    // ============ چک 2: توابع ============
    echo "<div class='card'>";
    echo "<div class='step-badge'>مرحله 2</div>";
    echo "<h2>⚙️ بررسی توابع</h2>";
    
    check(function_exists('bot'), "تابع bot() موجود است");
    check(function_exists('sendMessage'), "تابع sendMessage() موجود است");
    check(function_exists('setUser'), "تابع setUser() موجود است");
    check(function_exists('RandomString'), "تابع RandomString() موجود است");
    
    echo "</div>";
    
    // ============ چک 3: اتصال به تلگرام ============
    echo "<div class='card'>";
    echo "<div class='step-badge'>مرحله 3</div>";
    echo "<h2>📡 بررسی اتصال به تلگرام</h2>";
    
    $bot_test = bot('getMe', []);
    check($bot_test && isset($bot_test->result), "اتصال به API تلگرام برقرار است", 
          "نام ربات: " . ($bot_test->result->first_name ?? 'نامشخص'));
    
    if($bot_test && isset($bot_test->result)){
        echo "<pre>Bot Info: " . json_encode($bot_test->result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
    }
    
    echo "</div>";
    
    // ============ چک 4: کد bot.php ============
    echo "<div class='card'>";
    echo "<div class='step-badge'>مرحله 4</div>";
    echo "<h2>📄 بررسی کد bot.php</h2>";
    
    if(file_exists('bot.php')){
        $bot_code = file_get_contents('bot.php');
        
        check(strpos($bot_code, 'uploadReceiptForPlan') !== false, 
              "کد handler فیش (uploadReceiptForPlan) موجود است");
        
        check(strpos($bot_code, 'user_id`, `hash_id`, `type`, `price') !== false, 
              "نام ستون‌های صحیح در INSERT استفاده شده", 
              "باید user_id, hash_id, price باشد نه userId, hashId, amount");
        
        check(strpos($bot_code, '📸 فیش دریافت شد') !== false, 
              "لاگ دریافت فیش موجود است");
        
        check(strpos($bot_code, '!isset($photo)') !== false, 
              "بررسی isset(\$photo) موجود است");
              
        check(strpos($bot_code, 'sendPhoto') !== false || strpos($bot_code, 'bot(\'sendPhoto\'') !== false, 
              "کد ارسال عکس به ادمین موجود است");
    }
    
    echo "</div>";
    
    // ============ چک 5: config.php ============
    echo "<div class='card'>";
    echo "<div class='step-badge'>مرحله 5</div>";
    echo "<h2>⚙️ بررسی config.php</h2>";
    
    if(file_exists('config.php')){
        $config_code = file_get_contents('config.php');
        
        check(strpos($config_code, '$photo') !== false, 
              "متغیر \$photo در config.php تعریف شده");
        
        check(strpos($config_code, 'update->message->photo') !== false, 
              "کد استخراج photo از update موجود است");
    }
    
    echo "</div>";
    
    // ============ نتیجه نهایی ============
    echo "<div class='card'>";
    echo "<h2>📊 نتیجه نهایی</h2>";
    
    $success_rate = ($success_count / $total_checks) * 100;
    
    echo "<p style='font-size:24px; margin:20px 0;'>";
    echo "✅ موفق: <strong>{$success_count}</strong> از <strong>{$total_checks}</strong> ";
    echo "(<strong>" . number_format($success_rate, 1) . "%</strong>)";
    echo "</p>";
    
    if(count($errors) == 0 && count($warnings) == 0){
        echo "<div class='success-box'>";
        echo "🎉 همه چیز کامل است! سیستم آماده کار است.";
        echo "</div>";
        
        echo "<h3>✅ مراحل بعدی:</h3>";
        echo "<ol style='font-size:16px; line-height:2; margin:20px 0;'>";
        echo "<li>به ربات برید</li>";
        echo "<li>خرید سرویس APN → انتخاب دسته → انتخاب پلن</li>";
        echo "<li>پرداخت فیش بانکی → ارسال عکس</li>";
        echo "<li>اگر کار نکرد: <a href='view_logs.php'>لاگ‌ها</a> را چک کنید</li>";
        echo "</ol>";
        
    } else {
        if(count($errors) > 0){
            echo "<div class='critical-box'>";
            echo "⛔ خطاهای کریتیکال یافت شد:";
            echo "<ul style='margin-top:10px;'>";
            foreach($errors as $err){
                echo "<li>{$err}</li>";
            }
            echo "</ul>";
            echo "</div>";
        }
        
        if(count($warnings) > 0){
            echo "<div class='check-item warning' style='margin:20px 0;'>";
            echo "⚠️ هشدارها:";
            echo "<ul style='margin-top:10px;'>";
            foreach($warnings as $warn){
                echo "<li>{$warn}</li>";
            }
            echo "</ul>";
            echo "</div>";
        }
    }
    
    echo "<div style='margin-top:30px; text-align:center;'>";
    echo "<a href='FINAL_DEBUG.php'><button>🧪 تست کامل سیستم</button></a>";
    echo "<a href='view_logs.php'><button>📋 مشاهده لاگ‌ها</button></a>";
    echo "<a href='debug_live.php'><button>📡 وضعیت زنده</button></a>";
    echo "</div>";
    
    echo "</div>";
    ?>
    
</div>
</body>
</html>
