# 📣 راهنمای سیستم ارسال پیام همگانی

## 🎯 امکانات

✅ ارسال پیام به **همه کاربران** ربات  
✅ پشتیبانی از **متن، عکس، ویدیو و فایل**  
✅ نمایش **پیشرفت لحظه‌ای** ارسال  
✅ گزارش **کامل و دقیق** از ارسال‌ها  
✅ امکان **لغو** قبل از ارسال  
✅ **محدودیت API** تلگرام رعایت می‌شود  

---

## 📖 نحوه استفاده

### روش 1️⃣: از طریق ربات (توصیه می‌شود)

#### مرحله 1: شروع ارسال
1. وارد ربات شوید
2. دکمه **"مدیریت ربات ⚙️"** را بزنید
3. دکمه **"📣 ارسال پیام همگانی"** را انتخاب کنید

#### مرحله 2: ارسال پیام
پیام خود را ارسال کنید. می‌توانید ارسال کنید:

- 📝 **متن ساده**
- 🖼️ **عکس** (با توضیحات اختیاری)
- 🎬 **ویدیو** (با توضیحات اختیاری)
- 📄 **فایل** (با توضیحات اختیاری)

#### مرحله 3: تأیید
پس از ارسال، پیش‌نمایشی نمایش داده می‌شود:

```
📊 پیش‌نمایش ارسال همگانی

👥 تعداد کاربران: 1,250

📝 نوع پیام: متن

━━━━━━━━━━━━━━━━━━━━━━

⚠️ آیا مطمئن هستید که می‌خواهید این پیام را برای همه ارسال کنید؟

[✅ بله، ارسال شود] [❌ خیر، لغو کن]
```

#### مرحله 4: نظارت بر پیشرفت
پس از تأیید، پیشرفت ارسال نمایش داده می‌شود:

```
📊 در حال ارسال...

✅ ارسال شده: 850
❌ ناموفق: 12
📈 پیشرفت: 862 از 1250 (68.9%)

⏱ زمان سپری شده: 04:23
⏳ زمان تخمینی باقیمانده: 02:05
```

#### مرحله 5: گزارش نهایی
پس از اتمام، گزارش کامل نمایش داده می‌شود:

```
✅ ارسال همگانی با موفقیت پایان یافت!

━━━━━━━━━━━━━━━━━━━━━━

📊 آمار کامل:

👥 کل کاربران: 1,250
✅ ارسال موفق: 1,238
❌ ارسال ناموفق: 12
📈 نرخ موفقیت: 99.0%

⏱ زمان کل: 6 دقیقه و 28 ثانیه

━━━━━━━━━━━━━━━━━━━━━━

⚠️ کاربران ناموفق:
• 123456789
• 987654321
...
```

---

### روش 2️⃣: ارسال خودکار (Cron Job)

برای ربات‌هایی با کاربران **زیاد** (بیشتر از 1000 نفر):

#### تنظیم Cron Job

1. **ویرایش کلید امنیتی:**
   - فایل `send_broadcast.php` را باز کنید
   - خط 17 را پیدا کنید:
   ```php
   $secretKey = "YOUR_SECRET_KEY_HERE";
   ```
   - یک کلید تصادفی قوی جایگزین کنید (مثلاً: `my_super_secret_key_2025`)

2. **تنظیم Cron در cPanel:**
   ```
   */5 * * * * curl "https://lotfisch.ir/send_broadcast.php?key=my_super_secret_key_2025"
   ```
   این کار هر **5 دقیقه** یک بار فایل را اجرا می‌کند تا پیام‌ها ارسال شوند.

3. **یا از طریق SSH:**
   ```bash
   */5 * * * * cd /path/to/robotali && php send_broadcast.php
   ```

#### مزایای Cron Job:
- ✅ ارسال **بدون timeout**
- ✅ برای **هزاران کاربر** مناسب
- ✅ ارسال در **پس‌زمینه**
- ✅ مصرف **منابع کمتر**

---

## 💡 نکات مهم

### ⚠️ محدودیت‌های تلگرام
تلگرام محدودیت‌هایی برای ارسال پیام دارد:
- حداکثر **30 پیام در ثانیه**
- حداکثر **20 پیام به کاربران مختلف در ثانیه**

ربات شما این محدودیت‌ها را **خودکار رعایت** می‌کند.

### 🎯 بهترین زمان ارسال
- **صبح 9-11** یا **عصر 17-20**
- **اجتناب از نیمه‌شب**
- **تعطیلات** = نرخ بازدید بالاتر

### 📝 نوشتن پیام خوب
```
❌ بد:
سلام خدمات جدید داریم بخرید

✅ خوب:
🔥 آفر ویژه فقط امروز! 🔥

💎 سرویس VIP نامحدود
⏰ فقط تا 24:00 امشب
💰 40% تخفیف

👉 از منوی ربات خرید کنید
```

### 🚫 چیزهایی که نباید بفرستید
- ❌ پیام‌های **اسپم**
- ❌ محتوای **نامناسب**
- ❌ لینک‌های **مشکوک**
- ❌ ارسال **مکرر** در روز (حداکثر 2-3 بار)

---

## 🔧 عیب‌یابی

### مشکل: "هیچ پیامی برای ارسال وجود ندارد"
**راه حل:** ابتدا یک پیام جدید ارسال کنید

### مشکل: "ارسال خیلی کند است"
**راه حل:** از Cron Job استفاده کنید

### مشکل: "برخی کاربران پیام را دریافت نکردند"
**دلایل احتمالی:**
- کاربر ربات را **بلاک** کرده
- کاربر ربات را **حذف** کرده
- مشکل در **اینترنت** کاربر

### مشکل: "پیام قطع شد"
**راه حل:** 
1. فایل `settings/messagewizwiz.json` را چک کنید
2. مقدار `offset` را به 0 تغییر دهید
3. دوباره تلاش کنید

---

## 📊 مثال‌های کاربردی

### 1️⃣ اعلام آفر ویژه
```
🎉 آفر ویژه آخر هفته! 🎉

💎 تمام پلن‌های VIP
🔥 30% تخفیف
⏰ فقط تا یکشنبه شب

🛍 همین الان خرید کنید!
/start
```

### 2️⃣ اطلاع‌رسانی مشکل
```
⚠️ اطلاعیه مهم

به دلیل تعمیرات سرور، ممکن است
در 2 ساعت آینده اتصال کند باشد.

✅ مشکل تا 22:00 برطرف می‌شود

🙏 از صبر شما متشکریم
```

### 3️⃣ معرفی محصول جدید
```
🆕 محصول جدید!

📈 پلن‌های Trading اضافه شدند
⚡️ پینگ فوق پایین
💰 قیمت استثنایی

👉 از منو انتخاب کنید:
پلن‌های Trading
```

---

## 🔐 امنیت

### توصیه‌ها:
1. **محدود کردن** دسترسی به فایل cron:
   ```php
   // در ابتدای send_broadcast.php
   $allowedIPs = ['127.0.0.1', 'YOUR_SERVER_IP'];
   if(!in_array($_SERVER['REMOTE_ADDR'], $allowedIPs)){
       die('Access denied');
   }
   ```

2. **تغییر منظم** کلید امنیتی

3. **بررسی لاگ‌ها** به صورت دوره‌ای

---

## 📞 پشتیبانی

در صورت بروز مشکل:
1. فایل `error_log` را بررسی کنید
2. فایل `settings/messagewizwiz.json` را چک کنید
3. با مدیر سیستم تماس بگیرید

---

**نسخه:** 2.0  
**آخرین بروزرسانی:** نوامبر 2025  
**ساخته شده با** ❤️ **برای ربات فروش VPN**
